/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import java.util.Arrays;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$CharDeser
extends PrimitiveArrayDeserializers<char[]> {
    private static final long serialVersionUID = 1L;

    public PrimitiveArrayDeserializers$CharDeser() {
        super(char[].class);
    }

    protected PrimitiveArrayDeserializers$CharDeser(PrimitiveArrayDeserializers$CharDeser primitiveArrayDeserializers$CharDeser, NullValueProvider nullValueProvider, Boolean bl) {
        super(primitiveArrayDeserializers$CharDeser, nullValueProvider, bl);
    }

    @Override
    protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl) {
        return this;
    }

    @Override
    protected final char[] _constructEmpty() {
        return new char[0];
    }

    @Override
    public final char[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            char[] cArray = jsonParser.getTextCharacters();
            int n2 = jsonParser.getTextOffset();
            int n3 = jsonParser.getTextLength();
            char[] cArray2 = new char[n3];
            System.arraycopy(cArray, n2, cArray2, 0, n3);
            return cArray2;
        }
        if (jsonParser.isExpectedStartArrayToken()) {
            JsonToken jsonToken;
            StringBuilder stringBuilder = new StringBuilder(64);
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                String string;
                if (jsonToken == JsonToken.VALUE_STRING) {
                    string = jsonParser.getText();
                } else if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    this._verifyNullForPrimitive(deserializationContext);
                    string = "\u0000";
                } else {
                    CharSequence charSequence = (CharSequence)deserializationContext.handleUnexpectedToken(Character.TYPE, jsonParser);
                    string = charSequence.toString();
                }
                if (string.length() != 1) {
                    deserializationContext.reportInputMismatch(this, "Cannot convert a JSON String of length %d into a char element of char array", string.length());
                }
                stringBuilder.append(string.charAt(0));
            }
            return stringBuilder.toString().toCharArray();
        }
        if (jsonParser.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT)) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof char[]) {
                return (char[])object;
            }
            if (object instanceof String) {
                return ((String)object).toCharArray();
            }
            if (object instanceof byte[]) {
                return Base64Variants.getDefaultVariant().encode((byte[])object, false).toCharArray();
            }
        }
        return (char[])deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    @Override
    protected final char[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return (char[])deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    @Override
    protected final char[] _concat(char[] cArray, char[] cArray2) {
        int n2 = cArray.length;
        int n3 = cArray2.length;
        cArray = Arrays.copyOf(cArray, n2 + n3);
        System.arraycopy(cArray2, 0, cArray, n2, n3);
        return cArray;
    }
}

