/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.util.ArrayBuilders$LongBuilder;
import java.util.Arrays;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$LongDeser
extends PrimitiveArrayDeserializers<long[]> {
    private static final long serialVersionUID = 1L;
    public static final PrimitiveArrayDeserializers$LongDeser instance = new PrimitiveArrayDeserializers$LongDeser();

    public PrimitiveArrayDeserializers$LongDeser() {
        super(long[].class);
    }

    protected PrimitiveArrayDeserializers$LongDeser(PrimitiveArrayDeserializers$LongDeser primitiveArrayDeserializers$LongDeser, NullValueProvider nullValueProvider, Boolean bl) {
        super(primitiveArrayDeserializers$LongDeser, nullValueProvider, bl);
    }

    @Override
    protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl) {
        return new PrimitiveArrayDeserializers$LongDeser(this, nullValueProvider, bl);
    }

    @Override
    protected final long[] _constructEmpty() {
        return new long[0];
    }

    @Override
    public final long[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return (long[])this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$LongBuilder arrayBuilders$LongBuilder = deserializationContext.getArrayBuilders().getLongBuilder();
        long[] lArray = (long[])arrayBuilders$LongBuilder.resetAndStart();
        int n2 = 0;
        try {
            JsonToken jsonToken;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                long l2;
                if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
                    l2 = jsonParser.getLongValue();
                } else if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    this._verifyNullForPrimitive(deserializationContext);
                    l2 = 0L;
                } else {
                    l2 = this._parseLongPrimitive(jsonParser, deserializationContext);
                }
                if (n2 >= lArray.length) {
                    lArray = arrayBuilders$LongBuilder.appendCompletedChunk(lArray, n2);
                    n2 = 0;
                }
                lArray[n2++] = l2;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)lArray, arrayBuilders$LongBuilder.bufferedSize() + n2);
        }
        return arrayBuilders$LongBuilder.completeAndClearBuffer(lArray, n2);
    }

    @Override
    protected final long[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return new long[]{this._parseLongPrimitive(jsonParser, deserializationContext)};
    }

    @Override
    protected final long[] _concat(long[] lArray, long[] lArray2) {
        int n2 = lArray.length;
        int n3 = lArray2.length;
        lArray = Arrays.copyOf(lArray, n2 + n3);
        System.arraycopy(lArray2, 0, lArray, n2, n3);
        return lArray;
    }
}

