/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.std.PrimitiveArrayDeserializers;
import com.fasterxml.jackson.databind.util.ArrayBuilders$ShortBuilder;
import java.util.Arrays;

@JacksonStdImpl
final class PrimitiveArrayDeserializers$ShortDeser
extends PrimitiveArrayDeserializers<short[]> {
    private static final long serialVersionUID = 1L;

    public PrimitiveArrayDeserializers$ShortDeser() {
        super(short[].class);
    }

    protected PrimitiveArrayDeserializers$ShortDeser(PrimitiveArrayDeserializers$ShortDeser primitiveArrayDeserializers$ShortDeser, NullValueProvider nullValueProvider, Boolean bl) {
        super(primitiveArrayDeserializers$ShortDeser, nullValueProvider, bl);
    }

    @Override
    protected final PrimitiveArrayDeserializers<?> withResolved(NullValueProvider nullValueProvider, Boolean bl) {
        return new PrimitiveArrayDeserializers$ShortDeser(this, nullValueProvider, bl);
    }

    @Override
    protected final short[] _constructEmpty() {
        return new short[0];
    }

    @Override
    public final short[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            return (short[])this.handleNonArray(jsonParser, deserializationContext);
        }
        ArrayBuilders$ShortBuilder arrayBuilders$ShortBuilder = deserializationContext.getArrayBuilders().getShortBuilder();
        short[] sArray = (short[])arrayBuilders$ShortBuilder.resetAndStart();
        int n2 = 0;
        try {
            JsonToken jsonToken;
            while ((jsonToken = jsonParser.nextToken()) != JsonToken.END_ARRAY) {
                short s2;
                if (jsonToken == JsonToken.VALUE_NULL) {
                    if (this._nuller != null) {
                        this._nuller.getNullValue(deserializationContext);
                        continue;
                    }
                    this._verifyNullForPrimitive(deserializationContext);
                    s2 = 0;
                } else {
                    s2 = this._parseShortPrimitive(jsonParser, deserializationContext);
                }
                if (n2 >= sArray.length) {
                    sArray = arrayBuilders$ShortBuilder.appendCompletedChunk(sArray, n2);
                    n2 = 0;
                }
                sArray[n2++] = s2;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)sArray, arrayBuilders$ShortBuilder.bufferedSize() + n2);
        }
        return arrayBuilders$ShortBuilder.completeAndClearBuffer(sArray, n2);
    }

    @Override
    protected final short[] handleSingleElementUnwrapped(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return new short[]{this._parseShortPrimitive(jsonParser, deserializationContext)};
    }

    @Override
    protected final short[] _concat(short[] sArray, short[] sArray2) {
        int n2 = sArray.length;
        int n3 = sArray2.length;
        sArray = Arrays.copyOf(sArray, n2 + n3);
        System.arraycopy(sArray2, 0, sArray, n2, n3);
        return sArray;
    }
}

