/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;

@JacksonStdImpl
final class StdKeyDeserializer$EnumKD
extends StdKeyDeserializer {
    private static final long serialVersionUID = 1L;
    protected final EnumResolver _byNameResolver;
    protected final AnnotatedMethod _factory;
    protected EnumResolver _byToStringResolver;
    protected final Enum<?> _enumDefaultValue;

    protected StdKeyDeserializer$EnumKD(EnumResolver enumResolver, AnnotatedMethod annotatedMethod) {
        super(-1, enumResolver.getEnumClass());
        this._byNameResolver = enumResolver;
        this._factory = annotatedMethod;
        this._enumDefaultValue = enumResolver.getDefaultValue();
    }

    @Override
    public final Object _parse(String string, DeserializationContext deserializationContext) {
        Enum<?> enum_;
        Serializable serializable;
        if (this._factory != null) {
            try {
                return ((AnnotatedWithParams)this._factory).call1(string);
            }
            catch (Exception exception) {
                serializable = exception;
                ClassUtil.unwrapAndThrowAsIAE(exception);
            }
        }
        if ((enum_ = ((EnumResolver)(serializable = deserializationContext.isEnabled(DeserializationFeature.READ_ENUMS_USING_TO_STRING) ? this._getToStringResolver(deserializationContext) : this._byNameResolver)).findEnum(string)) == null) {
            if (this._enumDefaultValue != null && deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE)) {
                enum_ = this._enumDefaultValue;
            } else if (!deserializationContext.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                return deserializationContext.handleWeirdKey(this._keyClass, string, "not one of the values accepted for Enum class: %s", ((EnumResolver)serializable).getEnumIds());
            }
        }
        return enum_;
    }

    private EnumResolver _getToStringResolver(DeserializationContext deserializationContext) {
        EnumResolver enumResolver = this._byToStringResolver;
        if (enumResolver == null) {
            StdKeyDeserializer$EnumKD stdKeyDeserializer$EnumKD = this;
            synchronized (stdKeyDeserializer$EnumKD) {
                this._byToStringResolver = enumResolver = EnumResolver.constructUsingToString(deserializationContext.getConfig(), this._byNameResolver.getEnumClass());
            }
        }
        return enumResolver;
    }
}

