/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonCreator$Mode;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.deser.KeyDeserializers;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$DelegatingKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$EnumKD;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$StringCtorKeyDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdKeyDeserializer$StringFactoryKeyDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedAndMetadata;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.EnumResolver;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.List;

public class StdKeyDeserializers
implements KeyDeserializers,
Serializable {
    private static final long serialVersionUID = 1L;

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver) {
        return new StdKeyDeserializer$EnumKD(enumResolver, null);
    }

    public static KeyDeserializer constructEnumKeyDeserializer(EnumResolver enumResolver, AnnotatedMethod annotatedMethod) {
        return new StdKeyDeserializer$EnumKD(enumResolver, annotatedMethod);
    }

    public static KeyDeserializer constructDelegatingKeyDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<?> jsonDeserializer) {
        return new StdKeyDeserializer$DelegatingKD(((ResolvedType)javaType).getRawClass(), jsonDeserializer);
    }

    public static KeyDeserializer findStringBasedKeyDeserializer(DeserializationConfig deserializationConfig, JavaType list) {
        AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator$Mode> annotatedAndMetadata2 = StdKeyDeserializers._findStringConstructor((BeanDescription)((Object)(list = deserializationConfig.introspectForCreation((JavaType)((Object)list)))));
        if (annotatedAndMetadata2 != null && annotatedAndMetadata2.metadata != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)annotatedAndMetadata2.annotated);
        }
        list = ((BeanDescription)((Object)list)).getFactoryMethodsWithMode();
        list.removeIf(annotatedAndMetadata -> ((AnnotatedWithParams)((AnnotatedMethod)annotatedAndMetadata.annotated)).getParameterCount() != 1 || ((AnnotatedWithParams)((AnnotatedMethod)annotatedAndMetadata.annotated)).getRawParameterType(0) != String.class || annotatedAndMetadata.metadata == JsonCreator$Mode.PROPERTIES);
        AnnotatedMethod annotatedMethod = StdKeyDeserializers._findExplicitStringFactoryMethod(list);
        if (annotatedMethod != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, annotatedMethod);
        }
        if (annotatedAndMetadata2 != null) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)annotatedAndMetadata2.annotated);
        }
        if (!list.isEmpty()) {
            return StdKeyDeserializers._constructCreatorKeyDeserializer(deserializationConfig, (AnnotatedMember)list.get((int)0).annotated);
        }
        return null;
    }

    private static KeyDeserializer _constructCreatorKeyDeserializer(DeserializationConfig deserializationConfig, AnnotatedMember object) {
        if (object instanceof AnnotatedConstructor) {
            object = ((AnnotatedConstructor)object).getAnnotated();
            if (deserializationConfig.canOverrideAccessModifiers()) {
                ClassUtil.checkAndFixAccess((Member)object, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
            }
            return new StdKeyDeserializer$StringCtorKeyDeserializer((Constructor<?>)object);
        }
        object = ((AnnotatedMethod)object).getAnnotated();
        if (deserializationConfig.canOverrideAccessModifiers()) {
            ClassUtil.checkAndFixAccess((Member)object, deserializationConfig.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
        }
        return new StdKeyDeserializer$StringFactoryKeyDeserializer((Method)object);
    }

    private static AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator$Mode> _findStringConstructor(BeanDescription object) {
        for (AnnotatedAndMetadata<AnnotatedConstructor, JsonCreator$Mode> annotatedAndMetadata : ((BeanDescription)((Object)object)).getConstructorsWithMode()) {
            AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)annotatedAndMetadata.annotated;
            if (((AnnotatedWithParams)annotatedConstructor).getParameterCount() != 1 || String.class != ((AnnotatedWithParams)annotatedConstructor).getRawParameterType(0)) continue;
            return annotatedAndMetadata;
        }
        return null;
    }

    private static AnnotatedMethod _findExplicitStringFactoryMethod(List<AnnotatedAndMetadata<AnnotatedMethod, JsonCreator$Mode>> clazz) {
        AnnotatedMethod annotatedMethod = null;
        clazz = clazz.iterator();
        while (clazz.hasNext()) {
            AnnotatedAndMetadata annotatedAndMetadata = (AnnotatedAndMetadata)clazz.next();
            if (annotatedAndMetadata.metadata == null) continue;
            if (annotatedMethod == null) {
                annotatedMethod = (AnnotatedMethod)annotatedAndMetadata.annotated;
                continue;
            }
            clazz = ((AnnotatedMember)((AnnotatedMethod)annotatedAndMetadata.annotated)).getDeclaringClass();
            throw new IllegalArgumentException("Multiple suitable annotated Creator factory methods to be used as the Key deserializer for type " + ClassUtil.nameOf(clazz));
        }
        return annotatedMethod;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type, DeserializationConfig deserializationConfig, BeanDescription beanDescription) {
        if (((Class)(type = ((ResolvedType)((Object)type)).getRawClass())).isPrimitive()) {
            type = ClassUtil.wrapperType(type);
        }
        return StdKeyDeserializer.forType(type);
    }
}

