/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.impl.NullsConstantProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.AccessPattern;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.io.Serializable;
import java.util.Objects;

@JacksonStdImpl
public final class StringArrayDeserializer
extends StdDeserializer<String[]>
implements ContextualDeserializer {
    private static final long serialVersionUID = 2L;
    private static final String[] NO_STRINGS = new String[0];
    public static final StringArrayDeserializer instance = new StringArrayDeserializer();
    protected JsonDeserializer<String> _elementDeserializer;
    protected final NullValueProvider _nullProvider;
    protected final Boolean _unwrapSingle;
    protected final boolean _skipNullValues;

    public StringArrayDeserializer() {
        this(null, null, null);
    }

    protected StringArrayDeserializer(JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Boolean bl) {
        super(String[].class);
        this._elementDeserializer = jsonDeserializer;
        this._nullProvider = nullValueProvider;
        this._unwrapSingle = bl;
        this._skipNullValues = NullsConstantProvider.isSkipper(nullValueProvider);
    }

    @Override
    public final LogicalType logicalType() {
        return LogicalType.Array;
    }

    @Override
    public final Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        return Boolean.TRUE;
    }

    @Override
    public final AccessPattern getEmptyAccessPattern() {
        return AccessPattern.CONSTANT;
    }

    @Override
    public final Object getEmptyValue(DeserializationContext deserializationContext) {
        return NO_STRINGS;
    }

    @Override
    public final JsonDeserializer<?> createContextual(DeserializationContext object, BeanProperty beanProperty) {
        JsonDeserializer<Object> jsonDeserializer = this._elementDeserializer;
        jsonDeserializer = this.findConvertingContentDeserializer((DeserializationContext)object, beanProperty, jsonDeserializer);
        Serializable serializable = ((DeserializationContext)object).constructType(String.class);
        jsonDeserializer = jsonDeserializer == null ? ((DeserializationContext)object).findContextualValueDeserializer((JavaType)serializable, beanProperty) : ((DeserializationContext)object).handleSecondaryContextualization(jsonDeserializer, beanProperty, (JavaType)serializable);
        serializable = this.findFormatFeature((DeserializationContext)object, beanProperty, String[].class, JsonFormat$Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        object = this.findContentNullProvider((DeserializationContext)object, beanProperty, jsonDeserializer);
        if (jsonDeserializer != null && this.isDefaultDeserializer(jsonDeserializer)) {
            jsonDeserializer = null;
        }
        if (this._elementDeserializer == jsonDeserializer && Objects.equals(this._unwrapSingle, serializable) && this._nullProvider == object) {
            return this;
        }
        return new StringArrayDeserializer(jsonDeserializer, (NullValueProvider)object, (Boolean)serializable);
    }

    @Override
    public final String[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        if (!jsonParser.isExpectedStartArrayToken()) {
            return this.handleNonArray(jsonParser, deserializationContext);
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(jsonParser, deserializationContext, null);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n2 = 0;
        try {
            while (true) {
                if ((object = jsonParser.nextTextValue()) == null) {
                    object = jsonParser.currentToken();
                    if (object == JsonToken.END_ARRAY) break;
                    if (object == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        object = (String)this._nullProvider.getNullValue(deserializationContext);
                    } else {
                        object = this._parseString(jsonParser, deserializationContext);
                    }
                }
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n2);
        }
        object = objectBuffer.completeAndClearBuffer(objectArray, n2, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    protected final String[] _deserializeCustom(JsonParser jsonParser, DeserializationContext deserializationContext, String[] objectArray) {
        Object object;
        int n2;
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        if (objectArray == null) {
            n2 = 0;
            objectArray = objectBuffer.resetAndStart();
        } else {
            n2 = objectArray.length;
            objectArray = objectBuffer.resetAndStart(objectArray, n2);
        }
        JsonDeserializer<String> jsonDeserializer = this._elementDeserializer;
        try {
            while (true) {
                if (jsonParser.nextTextValue() == null) {
                    object = jsonParser.currentToken();
                    if (object == JsonToken.END_ARRAY) break;
                    if (object == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) continue;
                        object = (String)this._nullProvider.getNullValue(deserializationContext);
                    } else {
                        object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                    }
                } else {
                    object = jsonDeserializer.deserialize(jsonParser, deserializationContext);
                }
                if (n2 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n2 = 0;
                }
                objectArray[n2++] = object;
            }
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, String.class, n2);
        }
        object = objectBuffer.completeAndClearBuffer(objectArray, n2, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    @Override
    public final Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return typeDeserializer.deserializeTypedFromArray(jsonParser, deserializationContext);
    }

    @Override
    public final String[] deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, String[] object) {
        if (!jsonParser.isExpectedStartArrayToken()) {
            String[] stringArray = this.handleNonArray(jsonParser, deserializationContext);
            if (stringArray == null) {
                return object;
            }
            int n2 = ((String[])object).length;
            String[] stringArray2 = new String[n2 + stringArray.length];
            System.arraycopy(object, 0, stringArray2, 0, n2);
            System.arraycopy(stringArray, 0, stringArray2, n2, stringArray.length);
            return stringArray2;
        }
        if (this._elementDeserializer != null) {
            return this._deserializeCustom(jsonParser, deserializationContext, (String[])object);
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        int n3 = ((String[])object).length;
        Object[] objectArray = objectBuffer.resetAndStart((Object[])object, n3);
        try {
            while (true) {
                if ((object = jsonParser.nextTextValue()) == null) {
                    object = jsonParser.currentToken();
                    if (object == JsonToken.END_ARRAY) break;
                    if (object == JsonToken.VALUE_NULL) {
                        if (this._skipNullValues) {
                            return NO_STRINGS;
                        }
                        object = (String)this._nullProvider.getNullValue(deserializationContext);
                    } else {
                        object = this._parseString(jsonParser, deserializationContext);
                    }
                }
                if (n3 >= objectArray.length) {
                    objectArray = objectBuffer.appendCompletedChunk(objectArray);
                    n3 = 0;
                }
                objectArray[n3++] = object;
            }
        }
        catch (Exception exception) {
            object = exception;
            throw JsonMappingException.wrapWithPath((Throwable)exception, (Object)objectArray, objectBuffer.bufferedSize() + n3);
        }
        object = objectBuffer.completeAndClearBuffer(objectArray, n3, String.class);
        deserializationContext.returnObjectBuffer(objectBuffer);
        return object;
    }

    private final String[] handleNonArray(JsonParser object, DeserializationContext deserializationContext) {
        boolean bl = this._unwrapSingle == Boolean.TRUE || this._unwrapSingle == null && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY);
        if (bl) {
            object = ((JsonParser)object).hasToken(JsonToken.VALUE_NULL) ? (String)this._nullProvider.getNullValue(deserializationContext) : this._parseString((JsonParser)object, deserializationContext);
            return new String[]{object};
        }
        if (((JsonParser)object).hasToken(JsonToken.VALUE_STRING)) {
            return (String[])this._deserializeFromString((JsonParser)object, deserializationContext);
        }
        return (String[])deserializationContext.handleUnexpectedToken(this._valueClass, (JsonParser)object);
    }
}

