/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;

@JacksonStdImpl
public class StringDeserializer
extends StdScalarDeserializer<String> {
    private static final long serialVersionUID = 1L;
    public static final StringDeserializer instance = new StringDeserializer();

    public StringDeserializer() {
        super(String.class);
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Textual;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getEmptyValue(DeserializationContext deserializationContext) {
        return "";
    }

    @Override
    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return jsonParser.getText();
        }
        Object object = jsonParser.currentToken();
        if (object == JsonToken.START_ARRAY) {
            return (String)this._deserializeFromArray(jsonParser, deserializationContext);
        }
        if (object == JsonToken.VALUE_EMBEDDED_OBJECT) {
            object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof byte[]) {
                return deserializationContext.getBase64Variant().encode((byte[])object, false);
            }
            return ((Object)object).toString();
        }
        if (object == JsonToken.START_OBJECT) {
            StringDeserializer stringDeserializer = this;
            return deserializationContext.extractScalarFromObject(jsonParser, stringDeserializer, stringDeserializer._valueClass);
        }
        if (object.isScalarValue() && (object = jsonParser.getValueAsString()) != null) {
            return object;
        }
        return (String)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    @Override
    public String deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        return this.deserialize(jsonParser, deserializationContext);
    }
}

