/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ObjectBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JacksonStdImpl
public class UntypedObjectDeserializer$Vanilla
extends StdDeserializer<Object> {
    private static final long serialVersionUID = 1L;
    private static final int MAX_DEPTH = 1000;
    public static final UntypedObjectDeserializer$Vanilla std = new UntypedObjectDeserializer$Vanilla();
    protected final boolean _nonMerging;

    public UntypedObjectDeserializer$Vanilla() {
        this(false);
    }

    protected UntypedObjectDeserializer$Vanilla(boolean bl) {
        super(Object.class);
        this._nonMerging = bl;
    }

    public static UntypedObjectDeserializer$Vanilla instance(boolean bl) {
        if (bl) {
            return new UntypedObjectDeserializer$Vanilla(true);
        }
        return std;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Untyped;
    }

    @Override
    public Boolean supportsUpdate(DeserializationConfig deserializationConfig) {
        if (this._nonMerging) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this.deserialize(jsonParser, deserializationContext, 0);
    }

    @Override
    private Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) {
        switch (jsonParser.currentTokenId()) {
            case 1: {
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken == JsonToken.END_OBJECT) {
                    return new LinkedHashMap(2);
                }
            }
            case 5: {
                if (n2 > 1000) {
                    throw new JsonParseException(jsonParser, "JSON is too deeply nested.");
                }
                return this.mapObject(jsonParser, deserializationContext, n2);
            }
            case 3: {
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken == JsonToken.END_ARRAY) {
                    if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                        return UntypedObjectDeserializer.NO_OBJECTS;
                    }
                    return new ArrayList(2);
                }
                if (n2 > 1000) {
                    throw new JsonParseException(jsonParser, "JSON is too deeply nested.");
                }
                if (deserializationContext.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
                    return this.mapArrayToArray(jsonParser, deserializationContext, n2);
                }
                return this.mapArray(jsonParser, deserializationContext, n2);
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 6: {
                return jsonParser.getText();
            }
            case 7: {
                if (deserializationContext.hasSomeOfFeatures(F_MASK_INT_COERCIONS)) {
                    return this._coerceIntegral(jsonParser, deserializationContext);
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 2: {
                return new LinkedHashMap(2);
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) {
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 3: 
            case 5: {
                return typeDeserializer.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
            case 6: {
                return jsonParser.getText();
            }
            case 7: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS)) {
                    return jsonParser.getBigIntegerValue();
                }
                return jsonParser.getNumberValue();
            }
            case 8: {
                if (deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS)) {
                    return jsonParser.getDecimalValue();
                }
                return jsonParser.getNumberValue();
            }
            case 9: {
                return Boolean.TRUE;
            }
            case 10: {
                return Boolean.FALSE;
            }
            case 12: {
                return jsonParser.getEmbeddedObject();
            }
            case 11: {
                return null;
            }
        }
        return deserializationContext.handleUnexpectedToken(Object.class, jsonParser);
    }

    @Override
    public Object deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Object object) {
        if (this._nonMerging) {
            return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
        }
        switch (jsonParser.currentTokenId()) {
            case 2: 
            case 4: {
                return object;
            }
            case 1: {
                Object object2 = jsonParser.nextToken();
                if (object2 == JsonToken.END_OBJECT) {
                    return object;
                }
            }
            case 5: {
                if (!(object instanceof Map)) break;
                Object object2 = (Map)object;
                String string = jsonParser.currentName();
                do {
                    jsonParser.nextToken();
                    Object v2 = object2.get(string);
                    Object object3 = v2 != null ? ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext, v2) : ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
                    if (object3 == v2) continue;
                    object2.put(string, object3);
                } while ((string = jsonParser.nextFieldName()) != null);
                return object;
            }
            case 3: {
                Object object4 = jsonParser.nextToken();
                if (object4 == JsonToken.END_ARRAY) {
                    return object;
                }
                if (!(object instanceof Collection)) break;
                object4 = (Collection)object;
                do {
                    object4.add(((JsonDeserializer)this).deserialize(jsonParser, deserializationContext));
                } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
                return object;
            }
        }
        return ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
    }

    @Deprecated
    protected Object mapArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this.mapArray(jsonParser, deserializationContext, 0);
    }

    protected Object mapArray(JsonParser object, DeserializationContext deserializationContext, int n2) {
        Object object2 = this.deserialize((JsonParser)object, deserializationContext, ++n2);
        if (((JsonParser)object).nextToken() == JsonToken.END_ARRAY) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object2);
            return arrayList;
        }
        Object object3 = this.deserialize((JsonParser)object, deserializationContext, n2);
        if (((JsonParser)object).nextToken() == JsonToken.END_ARRAY) {
            ArrayList<Object> arrayList = new ArrayList<Object>(2);
            arrayList.add(object2);
            arrayList.add(object3);
            return arrayList;
        }
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n3 = 0;
        ++n3;
        objectArray[0] = object2;
        ++n3;
        objectArray[1] = object3;
        int n4 = 2;
        do {
            object2 = this.deserialize((JsonParser)object, deserializationContext, n2);
            ++n4;
            if (n3 >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n3 = 0;
            }
            objectArray[n3++] = object2;
        } while (((JsonParser)object).nextToken() != JsonToken.END_ARRAY);
        object = new ArrayList(n4);
        objectBuffer.completeAndClearBuffer(objectArray, n3, (List<Object>)object);
        return object;
    }

    @Deprecated
    protected Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this.mapArrayToArray(jsonParser, deserializationContext, 0);
    }

    protected Object[] mapArrayToArray(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) {
        ++n2;
        ObjectBuffer objectBuffer = deserializationContext.leaseObjectBuffer();
        Object[] objectArray = objectBuffer.resetAndStart();
        int n3 = 0;
        do {
            Object object = this.deserialize(jsonParser, deserializationContext, n2);
            if (n3 >= objectArray.length) {
                objectArray = objectBuffer.appendCompletedChunk(objectArray);
                n3 = 0;
            }
            objectArray[n3++] = object;
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return objectBuffer.completeAndClearBuffer(objectArray, n3);
    }

    @Deprecated
    protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this.mapObject(jsonParser, deserializationContext, 0);
    }

    protected Object mapObject(JsonParser jsonParser, DeserializationContext deserializationContext, int n2) {
        Object object = jsonParser.currentName();
        jsonParser.nextToken();
        Object object2 = this.deserialize(jsonParser, deserializationContext, ++n2);
        String string = jsonParser.nextFieldName();
        if (string == null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(2);
            linkedHashMap.put((String)object, object2);
            return linkedHashMap;
        }
        jsonParser.nextToken();
        Object object3 = this.deserialize(jsonParser, deserializationContext, n2);
        String string2 = jsonParser.nextFieldName();
        if (string2 == null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(4);
            linkedHashMap.put((String)object, object2);
            if (linkedHashMap.put(string, object3) != null) {
                return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, (String)object, object2, object3, string2);
            }
            return linkedHashMap;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        linkedHashMap.put((String)object, object2);
        if (linkedHashMap.put(string, object3) != null) {
            return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, (String)object, object2, object3, string2);
        }
        do {
            jsonParser.nextToken();
            object = this.deserialize(jsonParser, deserializationContext, n2);
            object2 = linkedHashMap.put(string2, object);
            if (object2 == null) continue;
            return this._mapObjectWithDups(jsonParser, deserializationContext, linkedHashMap, string2, object2, object, jsonParser.nextFieldName());
        } while ((string2 = jsonParser.nextFieldName()) != null);
        return linkedHashMap;
    }

    protected Object _mapObjectWithDups(JsonParser jsonParser, DeserializationContext deserializationContext, Map<String, Object> map, String string, Object object, Object object2, String string2) {
        boolean bl = deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES);
        if (bl) {
            this._squashDups(map, string, object, object2);
        }
        while (string2 != null) {
            jsonParser.nextToken();
            object2 = ((JsonDeserializer)this).deserialize(jsonParser, deserializationContext);
            object = map.put(string2, object2);
            if (object != null && bl) {
                this._squashDups(map, string2, object, object2);
            }
            string2 = jsonParser.nextFieldName();
        }
        return map;
    }

    private void _squashDups(Map<String, Object> map, String string, Object object, Object object2) {
        if (object instanceof List) {
            ((List)object).add(object2);
            map.put(string, object);
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object);
        arrayList.add(object2);
        map.put(string, arrayList);
    }
}

