/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.exc;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.exc.MismatchedInputException;
import com.fasterxml.jackson.databind.util.ClassUtil;

public class InvalidNullException
extends MismatchedInputException {
    private static final long serialVersionUID = 1L;
    protected final PropertyName _propertyName;

    protected InvalidNullException(DeserializationContext deserializationContext, String string, PropertyName propertyName) {
        super(deserializationContext.getParser(), string);
        this._propertyName = propertyName;
    }

    public static InvalidNullException from(DeserializationContext serializable, PropertyName propertyName, JavaType javaType) {
        String string = String.format("Invalid `null` value encountered for property %s", ClassUtil.quotedOr(propertyName, "<UNKNOWN>"));
        serializable = new InvalidNullException((DeserializationContext)serializable, string, propertyName);
        if (javaType != null) {
            ((MismatchedInputException)serializable).setTargetType(javaType);
        }
        return serializable;
    }

    public PropertyName getPropertyName() {
        return this._propertyName;
    }
}

