/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor$Serialization;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Type;

public final class AnnotatedConstructor
extends AnnotatedWithParams {
    private static final long serialVersionUID = 1L;
    protected final Constructor<?> _constructor;
    protected AnnotatedConstructor$Serialization _serialization;

    public AnnotatedConstructor(TypeResolutionContext typeResolutionContext, Constructor<?> constructor, AnnotationMap annotationMap, AnnotationMap[] annotationMapArray) {
        super(typeResolutionContext, annotationMap, annotationMapArray);
        if (constructor == null) {
            throw new IllegalArgumentException("Null constructor not allowed");
        }
        this._constructor = constructor;
    }

    protected AnnotatedConstructor(AnnotatedConstructor$Serialization annotatedConstructor$Serialization) {
        super(null, null, null);
        this._constructor = null;
        this._serialization = annotatedConstructor$Serialization;
    }

    @Override
    public final AnnotatedConstructor withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedConstructor(this._typeContext, this._constructor, annotationMap, this._paramAnnotations);
    }

    @Override
    public final Constructor<?> getAnnotated() {
        return this._constructor;
    }

    @Override
    public final int getModifiers() {
        return this._constructor.getModifiers();
    }

    @Override
    public final String getName() {
        return this._constructor.getName();
    }

    @Override
    public final JavaType getType() {
        return this._typeContext.resolveType(((Annotated)this).getRawType());
    }

    @Override
    public final Class<?> getRawType() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public final int getParameterCount() {
        return this._constructor.getParameterTypes().length;
    }

    @Override
    public final Class<?> getRawParameterType(int n2) {
        Class<?>[] classArray = this._constructor.getParameterTypes();
        if (n2 >= classArray.length) {
            return null;
        }
        return classArray[n2];
    }

    @Override
    public final JavaType getParameterType(int n2) {
        Type[] typeArray = this._constructor.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return this._typeContext.resolveType(typeArray[n2]);
    }

    @Override
    @Deprecated
    public final Type getGenericParameterType(int n2) {
        Type[] typeArray = this._constructor.getGenericParameterTypes();
        if (n2 >= typeArray.length) {
            return null;
        }
        return typeArray[n2];
    }

    @Override
    public final Object call() {
        return this._constructor.newInstance(null);
    }

    @Override
    public final Object call(Object[] objectArray) {
        return this._constructor.newInstance(objectArray);
    }

    @Override
    public final Object call1(Object object) {
        return this._constructor.newInstance(object);
    }

    @Override
    public final Class<?> getDeclaringClass() {
        return this._constructor.getDeclaringClass();
    }

    @Override
    public final Member getMember() {
        return this._constructor;
    }

    @Override
    public final void setValue(Object object, Object object2) {
        throw new UnsupportedOperationException("Cannot call setValue() on constructor of " + ((AnnotatedMember)this).getDeclaringClass().getName());
    }

    @Override
    public final Object getValue(Object object) {
        throw new UnsupportedOperationException("Cannot call getValue() on constructor of " + ((AnnotatedMember)this).getDeclaringClass().getName());
    }

    @Override
    public final String toString() {
        int n2 = this._constructor.getParameterTypes().length;
        return String.format("[constructor for %s (%d arg%s), annotations: %s", ClassUtil.nameOf(this._constructor.getDeclaringClass()), n2, n2 == 1 ? "" : "s", this._annotations);
    }

    @Override
    public final int hashCode() {
        return this._constructor.getName().hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        object = (AnnotatedConstructor)object;
        if (((AnnotatedConstructor)object)._constructor == null) {
            return this._constructor == null;
        }
        return ((AnnotatedConstructor)object)._constructor.equals(this._constructor);
    }

    final Object writeReplace() {
        return new AnnotatedConstructor(new AnnotatedConstructor$Serialization(this._constructor));
    }

    final Object readResolve() {
        Class<?> clazz = this._serialization.clazz;
        try {
            Constructor<?> constructor = clazz.getDeclaredConstructor(this._serialization.args);
            if (!constructor.isAccessible()) {
                ClassUtil.checkAndFixAccess(constructor, false);
            }
            return new AnnotatedConstructor(null, constructor, null, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find constructor with " + this._serialization.args.length + " args from Class '" + clazz.getName());
        }
    }
}

