/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass$Creators;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotationCollector;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.CollectorBase;
import com.fasterxml.jackson.databind.introspect.MemberKey;
import com.fasterxml.jackson.databind.introspect.MethodGenericTypeResolver;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.ClassUtil$Ctor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class AnnotatedCreatorCollector
extends CollectorBase {
    private final TypeResolutionContext _typeContext;
    private final boolean _collectAnnotations;
    private AnnotatedConstructor _defaultConstructor;

    AnnotatedCreatorCollector(AnnotationIntrospector annotationIntrospector, TypeResolutionContext typeResolutionContext, boolean bl) {
        super(annotationIntrospector);
        this._typeContext = typeResolutionContext;
        this._collectAnnotations = bl;
    }

    public static AnnotatedClass$Creators collectCreators(AnnotationIntrospector annotationIntrospector, TypeFactory typeFactory, TypeResolutionContext typeResolutionContext, JavaType javaType, Class<?> clazz, boolean bl) {
        return new AnnotatedCreatorCollector(annotationIntrospector, typeResolutionContext, bl |= clazz != null).collect(typeFactory, javaType, clazz);
    }

    final AnnotatedClass$Creators collect(TypeFactory object, JavaType javaType, Class<?> clazz) {
        List<AnnotatedConstructor> list = this._findPotentialConstructors(javaType, clazz);
        object = this._findPotentialFactories((TypeFactory)object, javaType, clazz);
        if (this._collectAnnotations) {
            if (this._defaultConstructor != null && this._intr.hasIgnoreMarker(this._defaultConstructor)) {
                this._defaultConstructor = null;
            }
            int n2 = list.size();
            while (--n2 >= 0) {
                if (!this._intr.hasIgnoreMarker(list.get(n2))) continue;
                list.remove(n2);
            }
            n2 = object.size();
            while (--n2 >= 0) {
                if (!this._intr.hasIgnoreMarker((AnnotatedMember)object.get(n2))) continue;
                object.remove(n2);
            }
        }
        return new AnnotatedClass$Creators(this._defaultConstructor, list, (List<AnnotatedMethod>)object);
    }

    private List<AnnotatedConstructor> _findPotentialConstructors(JavaType object, Class<?> clazz) {
        int n2;
        int n3;
        ClassUtil$Ctor classUtil$Ctor = null;
        ArrayList<ClassUtil$Ctor> arrayList = null;
        if (!((ResolvedType)object).isEnumType()) {
            object = ClassUtil.getConstructors(((ResolvedType)object).getRawClass());
            ClassUtil$Ctor[] classUtil$CtorArray = object;
            n3 = ((ClassUtil$Ctor[])object).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                ClassUtil$Ctor classUtil$Ctor2 = classUtil$CtorArray[i2];
                if (!AnnotatedCreatorCollector.isIncludableConstructor(classUtil$Ctor2.getConstructor())) continue;
                if (classUtil$Ctor2.getParamCount() == 0) {
                    classUtil$Ctor = classUtil$Ctor2;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<ClassUtil$Ctor>();
                }
                arrayList.add(classUtil$Ctor2);
            }
        }
        if (arrayList == null) {
            object = Collections.emptyList();
            if (classUtil$Ctor == null) {
                return object;
            }
            n2 = 0;
        } else {
            n2 = arrayList.size();
            object = new ArrayList(n2);
            for (n3 = 0; n3 < n2; ++n3) {
                object.add(null);
            }
        }
        if (clazz != null) {
            MemberKey[] memberKeyArray = null;
            block2: for (ClassUtil$Ctor classUtil$Ctor3 : ClassUtil.getConstructors(clazz)) {
                if (classUtil$Ctor3.getParamCount() == 0) {
                    if (classUtil$Ctor == null) continue;
                    this._defaultConstructor = this.constructDefaultConstructor(classUtil$Ctor, classUtil$Ctor3);
                    classUtil$Ctor = null;
                    continue;
                }
                if (arrayList == null) continue;
                if (memberKeyArray == null) {
                    memberKeyArray = new MemberKey[n2];
                    for (int i3 = 0; i3 < n2; ++i3) {
                        memberKeyArray[i3] = new MemberKey(((ClassUtil$Ctor)arrayList.get(i3)).getConstructor());
                    }
                }
                MemberKey memberKey = new MemberKey(classUtil$Ctor3.getConstructor());
                for (int i4 = 0; i4 < n2; ++i4) {
                    if (!memberKey.equals(memberKeyArray[i4])) continue;
                    object.set(i4, this.constructNonDefaultConstructor((ClassUtil$Ctor)arrayList.get(i4), classUtil$Ctor3));
                    continue block2;
                }
            }
        }
        if (classUtil$Ctor != null) {
            this._defaultConstructor = this.constructDefaultConstructor(classUtil$Ctor, null);
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)object.get(i5);
            if (annotatedConstructor != null) continue;
            object.set(i5, this.constructNonDefaultConstructor((ClassUtil$Ctor)arrayList.get(i5), null));
        }
        return object;
    }

    private List<AnnotatedMethod> _findPotentialFactories(TypeFactory typeFactory, JavaType javaType, Class<?> object) {
        ArrayList<Method> arrayList = null;
        for (Method method : ClassUtil.getClassMethods(((ResolvedType)javaType).getRawClass())) {
            if (!AnnotatedCreatorCollector._isIncludableFactoryMethod(method)) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<Method>();
            }
            arrayList.add(method);
        }
        if (arrayList == null) {
            return Collections.emptyList();
        }
        TypeResolutionContext typeResolutionContext = this._typeContext;
        int n2 = arrayList.size();
        ArrayList<AnnotatedMethod> arrayList2 = new ArrayList<AnnotatedMethod>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList2.add(null);
        }
        if (object != null) {
            MemberKey[] memberKeyArray = null;
            block2: for (Method method : ((Class)object).getDeclaredMethods()) {
                if (!AnnotatedCreatorCollector._isIncludableFactoryMethod(method)) continue;
                if (memberKeyArray == null) {
                    memberKeyArray = new MemberKey[n2];
                    for (int i3 = 0; i3 < n2; ++i3) {
                        memberKeyArray[i3] = new MemberKey((Method)arrayList.get(i3));
                    }
                }
                MemberKey memberKey = new MemberKey(method);
                for (int i4 = 0; i4 < n2; ++i4) {
                    if (!memberKey.equals(memberKeyArray[i4])) continue;
                    arrayList2.set(i4, this.constructFactoryCreator((Method)arrayList.get(i4), typeResolutionContext, method));
                    continue block2;
                }
            }
        }
        for (int i5 = 0; i5 < n2; ++i5) {
            AnnotatedMethod annotatedMethod = (AnnotatedMethod)arrayList2.get(i5);
            if (annotatedMethod != null) continue;
            Method method = (Method)arrayList.get(i5);
            TypeResolutionContext typeResolutionContext2 = MethodGenericTypeResolver.narrowMethodTypeParameters(method, javaType, typeFactory, typeResolutionContext);
            arrayList2.set(i5, this.constructFactoryCreator(method, typeResolutionContext2, null));
        }
        return arrayList2;
    }

    private static boolean _isIncludableFactoryMethod(Method method) {
        return Modifier.isStatic(method.getModifiers()) && !method.isSynthetic();
    }

    protected final AnnotatedConstructor constructDefaultConstructor(ClassUtil$Ctor classUtil$Ctor, ClassUtil$Ctor classUtil$Ctor2) {
        return new AnnotatedConstructor(this._typeContext, classUtil$Ctor.getConstructor(), this.collectAnnotations(classUtil$Ctor, classUtil$Ctor2), NO_ANNOTATION_MAPS);
    }

    protected final AnnotatedConstructor constructNonDefaultConstructor(ClassUtil$Ctor classUtil$Ctor, ClassUtil$Ctor classUtil$Ctor2) {
        AnnotationMap[] annotationMapArray;
        int n2 = classUtil$Ctor.getParamCount();
        if (this._intr == null) {
            return new AnnotatedConstructor(this._typeContext, classUtil$Ctor.getConstructor(), AnnotatedCreatorCollector._emptyAnnotationMap(), AnnotatedCreatorCollector._emptyAnnotationMaps(n2));
        }
        if (n2 == 0) {
            return new AnnotatedConstructor(this._typeContext, classUtil$Ctor.getConstructor(), this.collectAnnotations(classUtil$Ctor, classUtil$Ctor2), NO_ANNOTATION_MAPS);
        }
        Annotation[][] annotationArray = classUtil$Ctor.getParameterAnnotations();
        if (n2 != annotationArray.length) {
            annotationMapArray = null;
            Class<?> clazz = classUtil$Ctor.getDeclaringClass();
            if (ClassUtil.isEnumType(clazz) && n2 == annotationArray.length + 2) {
                annotationMapArray = annotationArray;
                annotationArray = new Annotation[annotationArray.length + 2][];
                System.arraycopy(annotationMapArray, 0, annotationArray, 2, annotationMapArray.length);
                annotationMapArray = this.collectAnnotations(annotationArray, null);
            } else if (clazz.isMemberClass() && n2 == annotationArray.length + 1) {
                annotationMapArray = annotationArray;
                annotationArray = new Annotation[annotationArray.length + 1][];
                System.arraycopy(annotationMapArray, 0, annotationArray, 1, annotationMapArray.length);
                annotationArray[0] = NO_ANNOTATIONS;
                annotationMapArray = this.collectAnnotations(annotationArray, null);
            }
            if (annotationMapArray == null) {
                throw new IllegalStateException(String.format("Internal error: constructor for %s has mismatch: %d parameters; %d sets of annotations", classUtil$Ctor.getDeclaringClass().getName(), n2, annotationArray.length));
            }
        } else {
            annotationMapArray = this.collectAnnotations(annotationArray, classUtil$Ctor2 == null ? null : classUtil$Ctor2.getParameterAnnotations());
        }
        return new AnnotatedConstructor(this._typeContext, classUtil$Ctor.getConstructor(), this.collectAnnotations(classUtil$Ctor, classUtil$Ctor2), annotationMapArray);
    }

    protected final AnnotatedMethod constructFactoryCreator(Method method, TypeResolutionContext typeResolutionContext, Method method2) {
        int n2 = method.getParameterTypes().length;
        if (this._intr == null) {
            return new AnnotatedMethod(typeResolutionContext, method, AnnotatedCreatorCollector._emptyAnnotationMap(), AnnotatedCreatorCollector._emptyAnnotationMaps(n2));
        }
        if (n2 == 0) {
            return new AnnotatedMethod(typeResolutionContext, method, this.collectAnnotations(method, method2), NO_ANNOTATION_MAPS);
        }
        return new AnnotatedMethod(typeResolutionContext, method, this.collectAnnotations(method, method2), this.collectAnnotations(method.getParameterAnnotations(), method2 == null ? null : method2.getParameterAnnotations()));
    }

    private AnnotationMap[] collectAnnotations(Annotation[][] annotationArray, Annotation[][] annotationArray2) {
        if (this._collectAnnotations) {
            int n2 = annotationArray.length;
            AnnotationMap[] annotationMapArray = new AnnotationMap[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                AnnotationCollector annotationCollector = this.collectAnnotations(AnnotationCollector.emptyCollector(), annotationArray[i2]);
                if (annotationArray2 != null) {
                    annotationCollector = this.collectAnnotations(annotationCollector, annotationArray2[i2]);
                }
                annotationMapArray[i2] = annotationCollector.asAnnotationMap();
            }
            return annotationMapArray;
        }
        return NO_ANNOTATION_MAPS;
    }

    private AnnotationMap collectAnnotations(ClassUtil$Ctor object, ClassUtil$Ctor classUtil$Ctor) {
        if (this._collectAnnotations) {
            object = this.collectAnnotations(((ClassUtil$Ctor)object).getDeclaredAnnotations());
            if (classUtil$Ctor != null) {
                object = this.collectAnnotations((AnnotationCollector)object, classUtil$Ctor.getDeclaredAnnotations());
            }
            return ((AnnotationCollector)object).asAnnotationMap();
        }
        return AnnotatedCreatorCollector._emptyAnnotationMap();
    }

    private final AnnotationMap collectAnnotations(AnnotatedElement object, AnnotatedElement annotatedElement) {
        object = this.collectAnnotations(object.getDeclaredAnnotations());
        if (annotatedElement != null) {
            object = this.collectAnnotations((AnnotationCollector)object, annotatedElement.getDeclaredAnnotations());
        }
        return ((AnnotationCollector)object).asAnnotationMap();
    }

    private static boolean isIncludableConstructor(Constructor<?> constructor) {
        return !constructor.isSynthetic();
    }
}

