/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedField$Serialization;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotationMap;
import com.fasterxml.jackson.databind.introspect.TypeResolutionContext;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;

public final class AnnotatedField
extends AnnotatedMember
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient Field _field;
    protected AnnotatedField$Serialization _serialization;

    public AnnotatedField(TypeResolutionContext typeResolutionContext, Field field, AnnotationMap annotationMap) {
        super(typeResolutionContext, annotationMap);
        this._field = field;
    }

    @Override
    public final AnnotatedField withAnnotations(AnnotationMap annotationMap) {
        return new AnnotatedField(this._typeContext, this._field, annotationMap);
    }

    protected AnnotatedField(AnnotatedField$Serialization annotatedField$Serialization) {
        super(null, null);
        this._field = null;
        this._serialization = annotatedField$Serialization;
    }

    @Override
    public final Field getAnnotated() {
        return this._field;
    }

    @Override
    public final int getModifiers() {
        return this._field.getModifiers();
    }

    @Override
    public final String getName() {
        return this._field.getName();
    }

    @Override
    public final Class<?> getRawType() {
        return this._field.getType();
    }

    @Override
    public final JavaType getType() {
        return this._typeContext.resolveType(this._field.getGenericType());
    }

    @Override
    public final Class<?> getDeclaringClass() {
        return this._field.getDeclaringClass();
    }

    @Override
    public final Member getMember() {
        return this._field;
    }

    @Override
    public final void setValue(Object object, Object object2) {
        try {
            this._field.set(object, object2);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to setValue() for field " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    @Override
    public final Object getValue(Object object) {
        try {
            return this._field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Failed to getValue() for field " + this.getFullName() + ": " + illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    public final int getAnnotationCount() {
        return this._annotations.size();
    }

    public final boolean isTransient() {
        return Modifier.isTransient(this.getModifiers());
    }

    @Override
    public final int hashCode() {
        return this._field.getName().hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!ClassUtil.hasClass(object, this.getClass())) {
            return false;
        }
        object = (AnnotatedField)object;
        if (((AnnotatedField)object)._field == null) {
            return this._field == null;
        }
        return ((AnnotatedField)object)._field.equals(this._field);
    }

    @Override
    public final String toString() {
        return "[field " + this.getFullName() + "]";
    }

    final Object writeReplace() {
        return new AnnotatedField(new AnnotatedField$Serialization(this._field));
    }

    final Object readResolve() {
        Class<?> clazz = this._serialization.clazz;
        try {
            Field field = clazz.getDeclaredField(this._serialization.name);
            if (!field.isAccessible()) {
                ClassUtil.checkAndFixAccess(field, false);
            }
            return new AnnotatedField(null, field, null);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not find method '" + this._serialization.name + "' from Class '" + clazz.getName());
        }
    }
}

