/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy$Provider;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedClassResolver;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector;
import com.fasterxml.jackson.databind.introspect.ClassIntrospector$MixInResolver;
import com.fasterxml.jackson.databind.introspect.DefaultAccessorNamingStrategy$Provider;
import com.fasterxml.jackson.databind.introspect.POJOPropertiesCollector;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;

public class BasicClassIntrospector
extends ClassIntrospector
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_STRING = String.class;
    private static final Class<?> CLS_JSON_NODE = JsonNode.class;
    protected static final BasicBeanDescription STRING_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(String.class), AnnotatedClassResolver.createPrimordial(CLS_STRING));
    protected static final BasicBeanDescription BOOLEAN_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Boolean.TYPE), AnnotatedClassResolver.createPrimordial(Boolean.TYPE));
    protected static final BasicBeanDescription INT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Integer.TYPE), AnnotatedClassResolver.createPrimordial(Integer.TYPE));
    protected static final BasicBeanDescription LONG_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Long.TYPE), AnnotatedClassResolver.createPrimordial(Long.TYPE));
    protected static final BasicBeanDescription OBJECT_DESC = BasicBeanDescription.forOtherUse(null, SimpleType.constructUnsafe(Object.class), AnnotatedClassResolver.createPrimordial(CLS_OBJECT));

    @Override
    public ClassIntrospector copy() {
        return new BasicClassIntrospector();
    }

    @Override
    public BasicBeanDescription forSerialization(SerializationConfig serializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(serializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(serializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forSerialization(this.collectProperties(serializationConfig, javaType, classIntrospector$MixInResolver, true));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserialization(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(deserializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, classIntrospector$MixInResolver, false));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver, BeanDescription beanDescription) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, classIntrospector$MixInResolver, beanDescription, false));
    }

    @Override
    @Deprecated
    public BasicBeanDescription forDeserializationWithBuilder(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        return BasicBeanDescription.forDeserialization(this.collectPropertiesWithBuilder(deserializationConfig, javaType, classIntrospector$MixInResolver, null, false));
    }

    @Override
    public BasicBeanDescription forCreation(DeserializationConfig deserializationConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(deserializationConfig, javaType);
        if (basicBeanDescription == null && (basicBeanDescription = this._findStdJdkCollectionDesc(deserializationConfig, javaType)) == null) {
            basicBeanDescription = BasicBeanDescription.forDeserialization(this.collectProperties(deserializationConfig, javaType, classIntrospector$MixInResolver, false));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(mapperConfig, javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, classIntrospector$MixInResolver));
        }
        return basicBeanDescription;
    }

    @Override
    public BasicBeanDescription forDirectClassAnnotations(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        BasicBeanDescription basicBeanDescription = this._findStdTypeDesc(mapperConfig, javaType);
        if (basicBeanDescription == null) {
            basicBeanDescription = BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedWithoutSuperTypes(mapperConfig, javaType, classIntrospector$MixInResolver));
        }
        return basicBeanDescription;
    }

    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver object, boolean bl) {
        object = this._resolveAnnotatedClass(mapperConfig, javaType, (ClassIntrospector$MixInResolver)object);
        AccessorNamingStrategy accessorNamingStrategy = javaType.isRecordType() ? mapperConfig.getAccessorNaming().forRecord(mapperConfig, (AnnotatedClass)object) : mapperConfig.getAccessorNaming().forPOJO(mapperConfig, (AnnotatedClass)object);
        return this.constructPropertyCollector(mapperConfig, (AnnotatedClass)object, javaType, bl, accessorNamingStrategy);
    }

    @Deprecated
    protected POJOPropertiesCollector collectProperties(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver object, boolean bl, String object2) {
        object = this._resolveAnnotatedClass(mapperConfig, javaType, (ClassIntrospector$MixInResolver)object);
        object2 = ((AccessorNamingStrategy$Provider)new DefaultAccessorNamingStrategy$Provider().withSetterPrefix((String)object2)).forPOJO(mapperConfig, (AnnotatedClass)object);
        return this.constructPropertyCollector(mapperConfig, (AnnotatedClass)object, javaType, bl, (AccessorNamingStrategy)object2);
    }

    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver object, BeanDescription object2, boolean bl) {
        object = this._resolveAnnotatedClass(mapperConfig, javaType, (ClassIntrospector$MixInResolver)object);
        object2 = mapperConfig.getAccessorNaming().forBuilder(mapperConfig, (AnnotatedClass)object, (BeanDescription)object2);
        return this.constructPropertyCollector(mapperConfig, (AnnotatedClass)object, javaType, bl, (AccessorNamingStrategy)object2);
    }

    @Deprecated
    protected POJOPropertiesCollector collectPropertiesWithBuilder(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver, boolean bl) {
        return this.collectPropertiesWithBuilder(mapperConfig, javaType, classIntrospector$MixInResolver, null, bl);
    }

    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl, AccessorNamingStrategy accessorNamingStrategy) {
        return new POJOPropertiesCollector(mapperConfig, bl, javaType, annotatedClass, accessorNamingStrategy);
    }

    @Deprecated
    protected POJOPropertiesCollector constructPropertyCollector(MapperConfig<?> mapperConfig, AnnotatedClass annotatedClass, JavaType javaType, boolean bl, String string) {
        return new POJOPropertiesCollector(mapperConfig, bl, javaType, annotatedClass, string);
    }

    protected BasicBeanDescription _findStdTypeDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        Class<?> clazz = ((ResolvedType)javaType).getRawClass();
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_DESC;
            }
            if (clazz == Long.TYPE) {
                return LONG_DESC;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_DESC;
            }
        } else if (ClassUtil.isJDKClass(clazz)) {
            if (clazz == CLS_OBJECT) {
                return OBJECT_DESC;
            }
            if (clazz == CLS_STRING) {
                return STRING_DESC;
            }
            if (clazz == Integer.class) {
                return INT_DESC;
            }
            if (clazz == Long.class) {
                return LONG_DESC;
            }
            if (clazz == Boolean.class) {
                return BOOLEAN_DESC;
            }
        } else if (CLS_JSON_NODE.isAssignableFrom(clazz)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, AnnotatedClassResolver.createPrimordial(clazz));
        }
        return null;
    }

    protected boolean _isStdJDKCollection(JavaType type) {
        if (!((ResolvedType)((Object)type)).isContainerType() || ((ResolvedType)((Object)type)).isArrayType()) {
            return false;
        }
        return ClassUtil.isJDKClass(type = ((ResolvedType)((Object)type)).getRawClass()) && (Collection.class.isAssignableFrom((Class<?>)type) || Map.class.isAssignableFrom((Class<?>)type));
    }

    protected BasicBeanDescription _findStdJdkCollectionDesc(MapperConfig<?> mapperConfig, JavaType javaType) {
        if (this._isStdJDKCollection(javaType)) {
            return BasicBeanDescription.forOtherUse(mapperConfig, javaType, this._resolveAnnotatedClass(mapperConfig, javaType, mapperConfig));
        }
        return null;
    }

    protected AnnotatedClass _resolveAnnotatedClass(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        return AnnotatedClassResolver.resolve(mapperConfig, javaType, classIntrospector$MixInResolver);
    }

    protected AnnotatedClass _resolveAnnotatedWithoutSuperTypes(MapperConfig<?> mapperConfig, JavaType javaType, ClassIntrospector$MixInResolver classIntrospector$MixInResolver) {
        return AnnotatedClassResolver.resolveWithoutSuperTypes(mapperConfig, javaType, classIntrospector$MixInResolver);
    }
}

