/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.annotation.JsonInclude$Value;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public abstract class ConcreteBeanPropertyBase
implements BeanProperty,
Serializable {
    private static final long serialVersionUID = 1L;
    protected final PropertyMetadata _metadata;
    protected transient List<PropertyName> _aliases;

    public ConcreteBeanPropertyBase(PropertyMetadata propertyMetadata) {
        this._metadata = propertyMetadata == null ? PropertyMetadata.STD_REQUIRED_OR_OPTIONAL : propertyMetadata;
    }

    public ConcreteBeanPropertyBase(ConcreteBeanPropertyBase concreteBeanPropertyBase) {
        this._metadata = concreteBeanPropertyBase._metadata;
    }

    @Override
    public boolean isRequired() {
        return this._metadata.isRequired();
    }

    @Override
    public PropertyMetadata getMetadata() {
        return this._metadata;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    @Deprecated
    public final JsonFormat$Value findFormatOverrides(AnnotationIntrospector annotationIntrospector) {
        AnnotatedMember annotatedMember;
        JsonFormat$Value jsonFormat$Value = null;
        if (annotationIntrospector != null && (annotatedMember = this.getMember()) != null) {
            jsonFormat$Value = annotationIntrospector.findFormat(annotatedMember);
        }
        if (jsonFormat$Value == null) {
            jsonFormat$Value = EMPTY_FORMAT;
        }
        return jsonFormat$Value;
    }

    @Override
    public JsonFormat$Value findPropertyFormat(MapperConfig<?> serializable, Class<?> serializable2) {
        AnnotatedMember annotatedMember;
        serializable2 = ((MapperConfig)serializable).getDefaultPropertyFormat((Class<?>)serializable2);
        JsonFormat$Value jsonFormat$Value = null;
        if ((serializable = ((MapperConfig)serializable).getAnnotationIntrospector()) != null && (annotatedMember = this.getMember()) != null) {
            jsonFormat$Value = ((AnnotationIntrospector)serializable).findFormat(annotatedMember);
        }
        if (serializable2 == null) {
            if (jsonFormat$Value == null) {
                return EMPTY_FORMAT;
            }
            return jsonFormat$Value;
        }
        if (jsonFormat$Value == null) {
            return serializable2;
        }
        return ((JsonFormat$Value)serializable2).withOverrides(jsonFormat$Value);
    }

    @Override
    public JsonInclude$Value findPropertyInclusion(MapperConfig<?> serializable, Class<?> serializable2) {
        AnnotationIntrospector annotationIntrospector = ((MapperConfig)serializable).getAnnotationIntrospector();
        AnnotatedMember annotatedMember = this.getMember();
        if (annotatedMember == null) {
            serializable = ((MapperConfig)serializable).getDefaultPropertyInclusion((Class<?>)serializable2);
            return serializable;
        }
        serializable = ((MapperConfig)serializable).getDefaultInclusion((Class<?>)serializable2, annotatedMember.getRawType());
        if (annotationIntrospector == null) {
            return serializable;
        }
        serializable2 = annotationIntrospector.findPropertyInclusion(annotatedMember);
        if (serializable == null) {
            return serializable2;
        }
        return ((JsonInclude$Value)serializable).withOverrides((JsonInclude$Value)serializable2);
    }

    @Override
    public List<PropertyName> findAliases(MapperConfig<?> serializable) {
        List<PropertyName> list = this._aliases;
        if (list == null) {
            AnnotatedMember annotatedMember;
            if ((serializable = ((MapperConfig)serializable).getAnnotationIntrospector()) != null && (annotatedMember = this.getMember()) != null) {
                list = ((AnnotationIntrospector)serializable).findPropertyAliases(annotatedMember);
            }
            if (list == null) {
                list = Collections.emptyList();
            }
            this._aliases = list;
        }
        return list;
    }
}

