/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.introspect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public final class MemberKey {
    static final Class<?>[] NO_CLASSES = new Class[0];
    final String _name;
    final Class<?>[] _argTypes;

    public MemberKey(Method method) {
        this(method.getName(), method.getParameterTypes());
    }

    public MemberKey(Constructor<?> constructor) {
        this("", constructor.getParameterTypes());
    }

    public MemberKey(String string, Class<?>[] classArray) {
        this._name = string;
        this._argTypes = classArray == null ? NO_CLASSES : classArray;
    }

    public final String getName() {
        return this._name;
    }

    public final int argCount() {
        return this._argTypes.length;
    }

    public final String toString() {
        return this._name + "(" + this._argTypes.length + "-args)";
    }

    public final int hashCode() {
        return this._name.hashCode() + this._argTypes.length;
    }

    public final boolean equals(Object classArray) {
        if (classArray == this) {
            return true;
        }
        if (classArray == null) {
            return false;
        }
        if (classArray.getClass() != this.getClass()) {
            return false;
        }
        classArray = (MemberKey)classArray;
        if (!this._name.equals(classArray._name)) {
            return false;
        }
        classArray = classArray._argTypes;
        int n2 = this._argTypes.length;
        if (classArray.length != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Class<?> clazz = classArray[i2];
            Class<?> clazz2 = this._argTypes[i2];
            if (clazz == clazz2) continue;
            return false;
        }
        return true;
    }
}

