/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jdk14;

import com.fasterxml.jackson.annotation.JsonCreator$Mode;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedWithParams;
import com.fasterxml.jackson.databind.jdk14.JDK14Util$RawTypeName;
import com.fasterxml.jackson.databind.jdk14.JDK14Util$RecordAccessor;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Collections;
import java.util.List;

class JDK14Util$CreatorLocator {
    protected final BeanDescription _beanDesc;
    protected final DeserializationConfig _config;
    protected final AnnotationIntrospector _intr;
    protected final List<AnnotatedConstructor> _constructors;
    protected final AnnotatedConstructor _primaryConstructor;
    protected final JDK14Util$RawTypeName[] _recordFields;

    JDK14Util$CreatorLocator(DeserializationContext deserializationContext, BeanDescription object) {
        this._beanDesc = object;
        this._intr = ((DatabindContext)deserializationContext).getAnnotationIntrospector();
        this._config = deserializationContext.getConfig();
        this._recordFields = JDK14Util$RecordAccessor.instance().getRecordFields(((BeanDescription)object).getBeanClass());
        int n2 = this._recordFields.length;
        AnnotatedConstructor annotatedConstructor = null;
        if (n2 == 0) {
            annotatedConstructor = ((BeanDescription)object).findDefaultConstructor();
            this._constructors = Collections.singletonList(annotatedConstructor);
        } else {
            this._constructors = ((BeanDescription)object).getConstructors();
            block0: for (AnnotatedConstructor annotatedConstructor2 : this._constructors) {
                if (((AnnotatedWithParams)annotatedConstructor2).getParameterCount() != n2) continue;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!((AnnotatedWithParams)annotatedConstructor2).getRawParameterType(i2).equals(this._recordFields[i2].rawType)) continue block0;
                }
                annotatedConstructor = annotatedConstructor2;
                break;
            }
        }
        if (annotatedConstructor == null) {
            throw new IllegalArgumentException("Failed to find the canonical Record constructor of type " + ClassUtil.getTypeDescription(this._beanDesc.getType()));
        }
        this._primaryConstructor = annotatedConstructor;
    }

    public AnnotatedConstructor locate(List<String> list) {
        for (AnnotatedConstructor annotatedConstructor : this._constructors) {
            JsonCreator$Mode jsonCreator$Mode = this._intr.findCreatorAnnotation(this._config, annotatedConstructor);
            if (jsonCreator$Mode == null || JsonCreator$Mode.DISABLED == jsonCreator$Mode) continue;
            if (JsonCreator$Mode.DELEGATING == jsonCreator$Mode) {
                return null;
            }
            if (annotatedConstructor == this._primaryConstructor) continue;
            return null;
        }
        JDK14Util$RawTypeName[] jDK14Util$RawTypeNameArray = this._recordFields;
        int n2 = this._recordFields.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            JDK14Util$RawTypeName jDK14Util$RawTypeName = jDK14Util$RawTypeNameArray[i2];
            list.add(jDK14Util$RawTypeName.name);
        }
        return this._primaryConstructor;
    }
}

