/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class AsDeductionTypeDeserializer
extends AsPropertyTypeDeserializer {
    private static final long serialVersionUID = 1L;
    private static final BitSet EMPTY_CLASS_FINGERPRINT = new BitSet(0);
    private final Map<String, Integer> fieldBitIndex;
    private final Map<BitSet, String> subtypeFingerprints;

    public AsDeductionTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, JavaType javaType2, DeserializationConfig deserializationConfig, Collection<NamedType> collection) {
        super(javaType, typeIdResolver, null, false, javaType2, null);
        this.fieldBitIndex = new HashMap<String, Integer>();
        this.subtypeFingerprints = this.buildFingerprints(deserializationConfig, collection);
    }

    public AsDeductionTypeDeserializer(AsDeductionTypeDeserializer asDeductionTypeDeserializer, BeanProperty beanProperty) {
        super(asDeductionTypeDeserializer, beanProperty);
        this.fieldBitIndex = asDeductionTypeDeserializer.fieldBitIndex;
        this.subtypeFingerprints = asDeductionTypeDeserializer.subtypeFingerprints;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        if (beanProperty == this._property) {
            return this;
        }
        return new AsDeductionTypeDeserializer(this, beanProperty);
    }

    protected Map<BitSet, String> buildFingerprints(DeserializationConfig deserializationConfig, Collection<NamedType> object) {
        boolean bl = deserializationConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        int n2 = 0;
        HashMap<BitSet, String> hashMap = new HashMap<BitSet, String>();
        object = object.iterator();
        while (object.hasNext()) {
            NamedType namedType = (NamedType)object.next();
            Object object2 = deserializationConfig.getTypeFactory().constructType(namedType.getType());
            object2 = deserializationConfig.introspect((JavaType)object2).findProperties();
            BitSet bitSet = new BitSet(n2 + object2.size());
            object2 = object2.iterator();
            while (object2.hasNext()) {
                Integer n3;
                Object object3 = (BeanPropertyDefinition)object2.next();
                object3 = ((BeanPropertyDefinition)object3).getName();
                if (bl) {
                    object3 = ((String)object3).toLowerCase();
                }
                if ((n3 = this.fieldBitIndex.get(object3)) == null) {
                    n3 = n2;
                    this.fieldBitIndex.put((String)object3, n2++);
                }
                bitSet.set(n3);
            }
            object2 = hashMap.put(bitSet, namedType.getType().getName());
            if (object2 == null) continue;
            throw new IllegalStateException(String.format("Subtypes %s and %s have the same signature and cannot be uniquely deduced.", object2, namedType.getType().getName()));
        }
        return hashMap;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        Object object2 = jsonParser.currentToken();
        if (object2 == JsonToken.START_OBJECT) {
            object2 = jsonParser.nextToken();
        } else if (object2 != JsonToken.FIELD_NAME) {
            return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, null, "Unexpected input");
        }
        if (object2 == JsonToken.END_OBJECT && (object = this.subtypeFingerprints.get(EMPTY_CLASS_FINGERPRINT)) != null) {
            return this._deserializeTypedForId(jsonParser, deserializationContext, null, (String)object);
        }
        object = new LinkedList<BitSet>(this.subtypeFingerprints.keySet());
        TokenBuffer tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
        boolean bl = ((DatabindContext)deserializationContext).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        while (object2 == JsonToken.FIELD_NAME) {
            object2 = jsonParser.currentName();
            if (bl) {
                object2 = ((String)object2).toLowerCase();
            }
            ((JsonGenerator)tokenBuffer).copyCurrentStructure(jsonParser);
            object2 = this.fieldBitIndex.get(object2);
            if (object2 != null) {
                AsDeductionTypeDeserializer.prune((List<BitSet>)object, (Integer)object2);
                if (object.size() == 1) {
                    return this._deserializeTypedForId(jsonParser, deserializationContext, tokenBuffer, this.subtypeFingerprints.get(object.get(0)));
                }
            }
            object2 = jsonParser.nextToken();
        }
        object2 = String.format("Cannot deduce unique subtype of %s (%d candidates match)", ClassUtil.getTypeDescription(this._baseType), object.size());
        return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, tokenBuffer, (String)object2);
    }

    private static void prune(List<BitSet> object, int n2) {
        object = object.iterator();
        while (object.hasNext()) {
            if (((BitSet)object.next()).get(n2)) continue;
            object.remove();
        }
    }
}

