/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import com.fasterxml.jackson.databind.util.TokenBuffer;

public class AsPropertyTypeDeserializer
extends AsArrayTypeDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JsonTypeInfo$As _inclusion;
    protected final String _msgForMissingId;

    public AsPropertyTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl, JavaType javaType2) {
        this(javaType, typeIdResolver, string, bl, javaType2, JsonTypeInfo$As.PROPERTY);
    }

    public AsPropertyTypeDeserializer(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl, JavaType javaType2, JsonTypeInfo$As jsonTypeInfo$As) {
        super(javaType, typeIdResolver, string, bl, javaType2);
        this._msgForMissingId = this._property == null ? String.format("missing type id property '%s'", this._typePropertyName) : String.format("missing type id property '%s' (for POJO property '%s')", this._typePropertyName, this._property.getName());
        this._inclusion = jsonTypeInfo$As;
    }

    public AsPropertyTypeDeserializer(AsPropertyTypeDeserializer asPropertyTypeDeserializer, BeanProperty beanProperty) {
        super(asPropertyTypeDeserializer, beanProperty);
        this._msgForMissingId = this._property == null ? String.format("missing type id property '%s'", this._typePropertyName) : String.format("missing type id property '%s' (for POJO property '%s')", this._typePropertyName, this._property.getName());
        this._inclusion = asPropertyTypeDeserializer._inclusion;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty beanProperty) {
        if (beanProperty == this._property) {
            return this;
        }
        return new AsPropertyTypeDeserializer(this, beanProperty);
    }

    @Override
    public JsonTypeInfo$As getTypeInclusion() {
        return this._inclusion;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser jsonParser, DeserializationContext deserializationContext) {
        Object object;
        if (jsonParser.canReadTypeId() && (object = jsonParser.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(jsonParser, deserializationContext, object);
        }
        object = jsonParser.currentToken();
        if (object == JsonToken.START_OBJECT) {
            object = jsonParser.nextToken();
        } else if (object != JsonToken.FIELD_NAME) {
            return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, null, this._msgForMissingId);
        }
        JsonGenerator jsonGenerator = null;
        boolean bl = ((DatabindContext)deserializationContext).isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        while (object == JsonToken.FIELD_NAME) {
            String string;
            object = jsonParser.currentName();
            jsonParser.nextToken();
            if ((((String)object).equals(this._typePropertyName) || bl && ((String)object).equalsIgnoreCase(this._typePropertyName)) && (string = jsonParser.getValueAsString()) != null) {
                return this._deserializeTypedForId(jsonParser, deserializationContext, (TokenBuffer)jsonGenerator, string);
            }
            if (jsonGenerator == null) {
                jsonGenerator = deserializationContext.bufferForInputBuffering(jsonParser);
            }
            jsonGenerator.writeFieldName((String)object);
            jsonGenerator.copyCurrentStructure(jsonParser);
            object = jsonParser.nextToken();
        }
        return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, (TokenBuffer)jsonGenerator, this._msgForMissingId);
    }

    protected Object _deserializeTypedForId(JsonParser jsonParser, DeserializationContext deserializationContext, TokenBuffer tokenBuffer, String string) {
        JsonDeserializer<Object> jsonDeserializer = this._findDeserializer(deserializationContext, string);
        if (this._typeIdVisible) {
            if (tokenBuffer == null) {
                tokenBuffer = deserializationContext.bufferForInputBuffering(jsonParser);
            }
            ((JsonGenerator)tokenBuffer).writeFieldName(jsonParser.currentName());
            ((JsonGenerator)tokenBuffer).writeString(string);
        }
        if (tokenBuffer != null) {
            jsonParser.clearCurrentToken();
            jsonParser = JsonParserSequence.createFlattened(false, tokenBuffer.asParser(jsonParser), jsonParser);
        }
        if (jsonParser.currentToken() != JsonToken.END_OBJECT) {
            jsonParser.nextToken();
        }
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }

    @Deprecated
    protected Object _deserializeTypedUsingDefaultImpl(JsonParser jsonParser, DeserializationContext deserializationContext, TokenBuffer tokenBuffer) {
        return this._deserializeTypedUsingDefaultImpl(jsonParser, deserializationContext, tokenBuffer, null);
    }

    protected Object _deserializeTypedUsingDefaultImpl(JsonParser jsonParser, DeserializationContext deserializationContext, TokenBuffer tokenBuffer, String string) {
        Object object;
        if (!((TypeDeserializer)this).hasDefaultImpl()) {
            object = TypeDeserializer.deserializeIfNatural(jsonParser, deserializationContext, this._baseType);
            if (object != null) {
                return object;
            }
            if (jsonParser.isExpectedStartArrayToken()) {
                return super.deserializeTypedFromAny(jsonParser, deserializationContext);
            }
            if (jsonParser.hasToken(JsonToken.VALUE_STRING) && deserializationContext.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && ((String)(object = jsonParser.getText().trim())).isEmpty()) {
                return null;
            }
        }
        if ((object = this._findDefaultImplDeserializer(deserializationContext)) == null) {
            object = this._handleMissingTypeId(deserializationContext, string);
            if (object == null) {
                return null;
            }
            object = deserializationContext.findContextualValueDeserializer((JavaType)object, this._property);
        }
        if (tokenBuffer != null) {
            ((JsonGenerator)tokenBuffer).writeEndObject();
            jsonParser = tokenBuffer.asParser(jsonParser);
            jsonParser.nextToken();
        }
        return ((JsonDeserializer)object).deserialize(jsonParser, deserializationContext);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser jsonParser, DeserializationContext deserializationContext) {
        if (jsonParser.hasToken(JsonToken.START_ARRAY)) {
            return super.deserializeTypedFromArray(jsonParser, deserializationContext);
        }
        return ((TypeDeserializer)this).deserializeTypedFromObject(jsonParser, deserializationContext);
    }
}

