/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.type.TypeFactory;

public class MinimalClassNameIdResolver
extends ClassNameIdResolver {
    protected final String _basePackageName;
    protected final String _basePackagePrefix;

    protected MinimalClassNameIdResolver(JavaType object, TypeFactory typeFactory, PolymorphicTypeValidator polymorphicTypeValidator) {
        super((JavaType)object, typeFactory, polymorphicTypeValidator);
        object = ((ResolvedType)object).getRawClass().getName();
        int n2 = ((String)object).lastIndexOf(46);
        if (n2 < 0) {
            this._basePackageName = "";
            this._basePackagePrefix = ".";
            return;
        }
        this._basePackagePrefix = ((String)object).substring(0, n2 + 1);
        this._basePackageName = ((String)object).substring(0, n2);
    }

    public static MinimalClassNameIdResolver construct(JavaType javaType, MapperConfig<?> mapperConfig, PolymorphicTypeValidator polymorphicTypeValidator) {
        return new MinimalClassNameIdResolver(javaType, mapperConfig.getTypeFactory(), polymorphicTypeValidator);
    }

    @Override
    public JsonTypeInfo$Id getMechanism() {
        return JsonTypeInfo$Id.MINIMAL_CLASS;
    }

    @Override
    public String idFromValue(Object object) {
        if (((String)(object = object.getClass().getName())).startsWith(this._basePackagePrefix)) {
            return ((String)object).substring(this._basePackagePrefix.length() - 1);
        }
        return object;
    }

    @Override
    protected JavaType _typeFromId(String string, DatabindContext databindContext) {
        if (string.startsWith(".")) {
            StringBuilder stringBuilder = new StringBuilder(string.length() + this._basePackageName.length());
            if (this._basePackageName.isEmpty()) {
                stringBuilder.append(string.substring(1));
            } else {
                stringBuilder.append(this._basePackageName).append(string);
            }
            string = stringBuilder.toString();
        }
        return super._typeFromId(string, databindContext);
    }
}

