/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator$Validity;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsDeductionTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsExistingPropertyTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsExternalTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsExternalTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsPropertyTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.impl.AsWrapperTypeSerializer;
import com.fasterxml.jackson.databind.jsontype.impl.ClassNameIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.LaissezFaireSubTypeValidator;
import com.fasterxml.jackson.databind.jsontype.impl.MinimalClassNameIdResolver;
import com.fasterxml.jackson.databind.jsontype.impl.TypeNameIdResolver;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.util.Collection;

public class StdTypeResolverBuilder
implements TypeResolverBuilder<StdTypeResolverBuilder> {
    protected JsonTypeInfo$Id _idType;
    protected JsonTypeInfo$As _includeAs;
    protected String _typeProperty;
    protected boolean _typeIdVisible = false;
    public Class<?> _defaultImpl;
    protected TypeIdResolver _customIdResolver;

    public StdTypeResolverBuilder() {
    }

    protected StdTypeResolverBuilder(JsonTypeInfo$Id jsonTypeInfo$Id, JsonTypeInfo$As jsonTypeInfo$As, String string) {
        this._idType = jsonTypeInfo$Id;
        this._includeAs = jsonTypeInfo$As;
        this._typeProperty = string;
    }

    public StdTypeResolverBuilder(StdTypeResolverBuilder stdTypeResolverBuilder, Class<?> clazz) {
        this._idType = stdTypeResolverBuilder._idType;
        this._includeAs = stdTypeResolverBuilder._includeAs;
        this._typeProperty = stdTypeResolverBuilder._typeProperty;
        this._typeIdVisible = stdTypeResolverBuilder._typeIdVisible;
        this._customIdResolver = stdTypeResolverBuilder._customIdResolver;
        this._defaultImpl = clazz;
    }

    public static StdTypeResolverBuilder noTypeInfoBuilder() {
        return new StdTypeResolverBuilder().init(JsonTypeInfo$Id.NONE, null);
    }

    @Override
    public StdTypeResolverBuilder init(JsonTypeInfo$Id jsonTypeInfo$Id, TypeIdResolver typeIdResolver) {
        if (jsonTypeInfo$Id == null) {
            throw new IllegalArgumentException("idType cannot be null");
        }
        this._idType = jsonTypeInfo$Id;
        this._customIdResolver = typeIdResolver;
        this._typeProperty = jsonTypeInfo$Id.getDefaultPropertyName();
        return this;
    }

    @Override
    public TypeSerializer buildTypeSerializer(SerializationConfig object, JavaType javaType, Collection<NamedType> collection) {
        if (this._idType == JsonTypeInfo$Id.NONE) {
            return null;
        }
        if (((ResolvedType)javaType).isPrimitive() && !this.allowPrimitiveTypes((MapperConfig<?>)object, javaType)) {
            return null;
        }
        object = this.idResolver((MapperConfig<?>)object, javaType, this.subTypeValidator((MapperConfig<?>)object), collection, true, false);
        if (this._idType == JsonTypeInfo$Id.DEDUCTION) {
            return new AsExistingPropertyTypeSerializer((TypeIdResolver)object, null, this._typeProperty);
        }
        switch (this._includeAs) {
            case WRAPPER_ARRAY: {
                return new AsArrayTypeSerializer((TypeIdResolver)object, null);
            }
            case PROPERTY: {
                return new AsPropertyTypeSerializer((TypeIdResolver)object, null, this._typeProperty);
            }
            case WRAPPER_OBJECT: {
                return new AsWrapperTypeSerializer((TypeIdResolver)object, null);
            }
            case EXTERNAL_PROPERTY: {
                return new AsExternalTypeSerializer((TypeIdResolver)object, null, this._typeProperty);
            }
            case EXISTING_PROPERTY: {
                return new AsExistingPropertyTypeSerializer((TypeIdResolver)object, null, this._typeProperty);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + (Object)((Object)this._includeAs));
    }

    @Override
    public TypeDeserializer buildTypeDeserializer(DeserializationConfig deserializationConfig, JavaType javaType, Collection<NamedType> collection) {
        if (this._idType == JsonTypeInfo$Id.NONE) {
            return null;
        }
        if (((ResolvedType)javaType).isPrimitive() && !this.allowPrimitiveTypes(deserializationConfig, javaType)) {
            return null;
        }
        Object object = this.verifyBaseTypeValidity(deserializationConfig, javaType);
        object = this.idResolver(deserializationConfig, javaType, (PolymorphicTypeValidator)object, collection, false, true);
        JavaType javaType2 = this.defineDefaultImpl(deserializationConfig, javaType);
        if (this._idType == JsonTypeInfo$Id.DEDUCTION) {
            return new AsDeductionTypeDeserializer(javaType, (TypeIdResolver)object, javaType2, deserializationConfig, collection);
        }
        switch (this._includeAs) {
            case WRAPPER_ARRAY: {
                return new AsArrayTypeDeserializer(javaType, (TypeIdResolver)object, this._typeProperty, this._typeIdVisible, javaType2);
            }
            case PROPERTY: 
            case EXISTING_PROPERTY: {
                return new AsPropertyTypeDeserializer(javaType, (TypeIdResolver)object, this._typeProperty, this._typeIdVisible, javaType2, this._includeAs);
            }
            case WRAPPER_OBJECT: {
                return new AsWrapperTypeDeserializer(javaType, (TypeIdResolver)object, this._typeProperty, this._typeIdVisible, javaType2);
            }
            case EXTERNAL_PROPERTY: {
                return new AsExternalTypeDeserializer(javaType, (TypeIdResolver)object, this._typeProperty, this._typeIdVisible, javaType2);
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type serializer for inclusion type: " + (Object)((Object)this._includeAs));
    }

    protected JavaType defineDefaultImpl(DeserializationConfig deserializationConfig, JavaType javaType) {
        if (this._defaultImpl != null) {
            if (this._defaultImpl == Void.class || this._defaultImpl == NoClass.class) {
                return deserializationConfig.getTypeFactory().constructType(this._defaultImpl);
            }
            if (((ResolvedType)javaType).hasRawClass(this._defaultImpl)) {
                return javaType;
            }
            if (javaType.isTypeOrSuperTypeOf(this._defaultImpl)) {
                return deserializationConfig.getTypeFactory().constructSpecializedType(javaType, this._defaultImpl);
            }
            if (((ResolvedType)javaType).hasRawClass(this._defaultImpl)) {
                return javaType;
            }
        }
        if (deserializationConfig.isEnabled(MapperFeature.USE_BASE_TYPE_AS_DEFAULT_IMPL) && !((ResolvedType)javaType).isAbstract()) {
            return javaType;
        }
        return null;
    }

    @Override
    public StdTypeResolverBuilder inclusion(JsonTypeInfo$As jsonTypeInfo$As) {
        if (jsonTypeInfo$As == null) {
            throw new IllegalArgumentException("includeAs cannot be null");
        }
        this._includeAs = jsonTypeInfo$As;
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeProperty(String string) {
        if (string == null || string.isEmpty()) {
            string = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = string;
        return this;
    }

    @Override
    public StdTypeResolverBuilder defaultImpl(Class<?> clazz) {
        this._defaultImpl = clazz;
        return this;
    }

    @Override
    public StdTypeResolverBuilder typeIdVisibility(boolean bl) {
        this._typeIdVisible = bl;
        return this;
    }

    @Override
    public StdTypeResolverBuilder withDefaultImpl(Class<?> clazz) {
        if (this._defaultImpl == clazz) {
            return this;
        }
        ClassUtil.verifyMustOverride(StdTypeResolverBuilder.class, this, "withDefaultImpl");
        return new StdTypeResolverBuilder(this, clazz);
    }

    @Override
    public Class<?> getDefaultImpl() {
        return this._defaultImpl;
    }

    public String getTypeProperty() {
        return this._typeProperty;
    }

    public boolean isTypeIdVisible() {
        return this._typeIdVisible;
    }

    protected TypeIdResolver idResolver(MapperConfig<?> mapperConfig, JavaType javaType, PolymorphicTypeValidator polymorphicTypeValidator, Collection<NamedType> collection, boolean bl, boolean bl2) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        if (this._idType == null) {
            throw new IllegalStateException("Cannot build, 'init()' not yet called");
        }
        switch (this._idType) {
            case DEDUCTION: 
            case CLASS: {
                return ClassNameIdResolver.construct(javaType, mapperConfig, polymorphicTypeValidator);
            }
            case MINIMAL_CLASS: {
                return MinimalClassNameIdResolver.construct(javaType, mapperConfig, polymorphicTypeValidator);
            }
            case NAME: {
                return TypeNameIdResolver.construct(mapperConfig, javaType, collection, bl, bl2);
            }
            case NONE: {
                return null;
            }
        }
        throw new IllegalStateException("Do not know how to construct standard type id resolver for idType: " + (Object)((Object)this._idType));
    }

    public PolymorphicTypeValidator subTypeValidator(MapperConfig<?> mapperConfig) {
        return mapperConfig.getPolymorphicTypeValidator();
    }

    protected PolymorphicTypeValidator verifyBaseTypeValidity(MapperConfig<?> mapperConfig, JavaType javaType) {
        PolymorphicTypeValidator polymorphicTypeValidator = this.subTypeValidator(mapperConfig);
        if (this._idType == JsonTypeInfo$Id.CLASS || this._idType == JsonTypeInfo$Id.MINIMAL_CLASS) {
            PolymorphicTypeValidator$Validity polymorphicTypeValidator$Validity = polymorphicTypeValidator.validateBaseType(mapperConfig, javaType);
            if (polymorphicTypeValidator$Validity == PolymorphicTypeValidator$Validity.DENIED) {
                return this.reportInvalidBaseType(mapperConfig, javaType, polymorphicTypeValidator);
            }
            if (polymorphicTypeValidator$Validity == PolymorphicTypeValidator$Validity.ALLOWED) {
                return LaissezFaireSubTypeValidator.instance;
            }
        }
        return polymorphicTypeValidator;
    }

    protected PolymorphicTypeValidator reportInvalidBaseType(MapperConfig<?> mapperConfig, JavaType javaType, PolymorphicTypeValidator polymorphicTypeValidator) {
        throw new IllegalArgumentException(String.format("Configured `PolymorphicTypeValidator` (of type %s) denied resolution of all subtypes of base type %s", ClassUtil.classNameOf(polymorphicTypeValidator), ClassUtil.classNameOf(((ResolvedType)javaType).getRawClass())));
    }

    protected boolean allowPrimitiveTypes(MapperConfig<?> mapperConfig, JavaType javaType) {
        return false;
    }
}

