/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.NullifyingDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TypeDeserializerBase
extends TypeDeserializer
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeIdResolver _idResolver;
    protected final JavaType _baseType;
    protected final BeanProperty _property;
    protected final JavaType _defaultImpl;
    protected final String _typePropertyName;
    protected final boolean _typeIdVisible;
    protected final Map<String, JsonDeserializer<Object>> _deserializers;
    protected JsonDeserializer<Object> _defaultImplDeserializer;

    protected TypeDeserializerBase(JavaType javaType, TypeIdResolver typeIdResolver, String string, boolean bl, JavaType javaType2) {
        this._baseType = javaType;
        this._idResolver = typeIdResolver;
        this._typePropertyName = ClassUtil.nonNullString(string);
        this._typeIdVisible = bl;
        this._deserializers = new ConcurrentHashMap<String, JsonDeserializer<Object>>(16, 0.75f, 2);
        this._defaultImpl = javaType2;
        this._property = null;
    }

    protected TypeDeserializerBase(TypeDeserializerBase typeDeserializerBase, BeanProperty beanProperty) {
        this._baseType = typeDeserializerBase._baseType;
        this._idResolver = typeDeserializerBase._idResolver;
        this._typePropertyName = typeDeserializerBase._typePropertyName;
        this._typeIdVisible = typeDeserializerBase._typeIdVisible;
        this._deserializers = typeDeserializerBase._deserializers;
        this._defaultImpl = typeDeserializerBase._defaultImpl;
        this._defaultImplDeserializer = typeDeserializerBase._defaultImplDeserializer;
        this._property = beanProperty;
    }

    @Override
    public abstract TypeDeserializer forProperty(BeanProperty var1);

    @Override
    public abstract JsonTypeInfo$As getTypeInclusion();

    public String baseTypeName() {
        return ((ResolvedType)this._baseType).getRawClass().getName();
    }

    @Override
    public final String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public Class<?> getDefaultImpl() {
        return ClassUtil.rawClass(this._defaultImpl);
    }

    @Override
    public boolean hasDefaultImpl() {
        return this._defaultImpl != null;
    }

    public JavaType baseType() {
        return this._baseType;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(this.getClass().getName());
        stringBuilder.append("; base-type:").append(this._baseType);
        stringBuilder.append("; id-resolver: ").append(this._idResolver);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    protected final JsonDeserializer<Object> _findDeserializer(DeserializationContext deserializationContext, String string) {
        Object object = this._deserializers.get(string);
        if (object == null) {
            object = this._idResolver.typeFromId(deserializationContext, string);
            if (object == null) {
                object = this._findDefaultImplDeserializer(deserializationContext);
                if (object == null) {
                    object = this._handleUnknownTypeId(deserializationContext, string);
                    if (object == null) {
                        return NullifyingDeserializer.instance;
                    }
                    object = deserializationContext.findContextualValueDeserializer((JavaType)object, this._property);
                }
            } else {
                if (this._baseType != null && this._baseType.getClass() == object.getClass() && !((ResolvedType)object).hasGenericTypes()) {
                    try {
                        object = ((DatabindContext)deserializationContext).constructSpecializedType(this._baseType, ((ResolvedType)object).getRawClass());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw deserializationContext.invalidTypeIdException(this._baseType, string, illegalArgumentException.getMessage());
                    }
                }
                object = deserializationContext.findContextualValueDeserializer((JavaType)object, this._property);
            }
            this._deserializers.put(string, (JsonDeserializer<Object>)object);
        }
        return object;
    }

    protected final JsonDeserializer<Object> _findDefaultImplDeserializer(DeserializationContext deserializationContext) {
        if (this._defaultImpl == null) {
            if (!deserializationContext.isEnabled(DeserializationFeature.FAIL_ON_INVALID_SUBTYPE)) {
                return NullifyingDeserializer.instance;
            }
            return null;
        }
        Type type = ((ResolvedType)this._defaultImpl).getRawClass();
        if (ClassUtil.isBogusClass(type)) {
            return NullifyingDeserializer.instance;
        }
        type = this._defaultImpl;
        synchronized (type) {
            if (this._defaultImplDeserializer == null) {
                this._defaultImplDeserializer = deserializationContext.findContextualValueDeserializer(this._defaultImpl, this._property);
            }
            return this._defaultImplDeserializer;
        }
    }

    @Deprecated
    protected Object _deserializeWithNativeTypeId(JsonParser jsonParser, DeserializationContext deserializationContext) {
        return this._deserializeWithNativeTypeId(jsonParser, deserializationContext, jsonParser.getTypeId());
    }

    protected Object _deserializeWithNativeTypeId(JsonParser jsonParser, DeserializationContext deserializationContext, Object jsonDeserializer) {
        if (jsonDeserializer == null) {
            jsonDeserializer = this._findDefaultImplDeserializer(deserializationContext);
            if (jsonDeserializer == null) {
                return deserializationContext.reportInputMismatch(this.baseType(), "No (native) type id found when one was expected for polymorphic type handling", new Object[0]);
            }
        } else {
            jsonDeserializer = jsonDeserializer instanceof String ? (String)((Object)jsonDeserializer) : String.valueOf(jsonDeserializer);
            jsonDeserializer = this._findDeserializer(deserializationContext, (String)((Object)jsonDeserializer));
        }
        return jsonDeserializer.deserialize(jsonParser, deserializationContext);
    }

    protected JavaType _handleUnknownTypeId(DeserializationContext deserializationContext, String string) {
        String string2 = this._idResolver.getDescForKnownTypeIds();
        string2 = string2 == null ? "type ids are not statically known" : "known type ids = " + string2;
        if (this._property != null) {
            string2 = String.format("%s (for POJO property '%s')", string2, this._property.getName());
        }
        return deserializationContext.handleUnknownTypeId(this._baseType, string, this._idResolver, string2);
    }

    protected JavaType _handleMissingTypeId(DeserializationContext deserializationContext, String string) {
        return deserializationContext.handleMissingTypeId(this._baseType, this._idResolver, string);
    }
}

