/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$Id;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public class TypeNameIdResolver
extends TypeIdResolverBase {
    protected final MapperConfig<?> _config;
    protected final ConcurrentHashMap<String, String> _typeToId;
    protected final Map<String, JavaType> _idToType;
    protected final boolean _caseInsensitive;

    protected TypeNameIdResolver(MapperConfig<?> mapperConfig, JavaType javaType, ConcurrentHashMap<String, String> concurrentHashMap, HashMap<String, JavaType> hashMap) {
        super(javaType, mapperConfig.getTypeFactory());
        this._config = mapperConfig;
        this._typeToId = concurrentHashMap;
        this._idToType = hashMap;
        this._caseInsensitive = mapperConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
    }

    public static TypeNameIdResolver construct(MapperConfig<?> mapperConfig, JavaType javaType, Collection<NamedType> object, boolean bl, boolean bl2) {
        HashMap<String, JavaType> hashMap;
        ConcurrentHashMap<String, String> concurrentHashMap;
        if (bl == bl2) {
            throw new IllegalArgumentException();
        }
        if (bl) {
            concurrentHashMap = new ConcurrentHashMap<String, String>();
            hashMap = null;
        } else {
            hashMap = new HashMap<String, JavaType>();
            concurrentHashMap = new ConcurrentHashMap(4);
        }
        boolean bl3 = mapperConfig.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_VALUES);
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                JavaType javaType2;
                Object object2 = (NamedType)object.next();
                Class<?> clazz = ((NamedType)object2).getType();
                Object object3 = object2 = ((NamedType)object2).hasName() ? ((NamedType)object2).getName() : TypeNameIdResolver._defaultTypeId(clazz);
                if (bl) {
                    concurrentHashMap.put(clazz.getName(), (String)object2);
                }
                if (!bl2) continue;
                if (bl3) {
                    object2 = ((String)object2).toLowerCase();
                }
                if ((javaType2 = hashMap.get(object2)) != null && clazz.isAssignableFrom(((ResolvedType)javaType2).getRawClass())) continue;
                hashMap.put((String)object2, mapperConfig.constructType(clazz));
            }
        }
        return new TypeNameIdResolver(mapperConfig, javaType, concurrentHashMap, hashMap);
    }

    @Override
    public JsonTypeInfo$Id getMechanism() {
        return JsonTypeInfo$Id.NAME;
    }

    @Override
    public String idFromValue(Object object) {
        return this.idFromClass(object.getClass());
    }

    protected String idFromClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        String string = clazz.getName();
        Object object = this._typeToId.get(string);
        if (object == null) {
            clazz = ((ResolvedType)this._typeFactory.constructType(clazz)).getRawClass();
            if (this._config.isAnnotationProcessingEnabled()) {
                object = this._config.introspectClassAnnotations(clazz);
                object = this._config.getAnnotationIntrospector().findTypeName(((BeanDescription)object).getClassInfo());
            }
            if (object == null) {
                object = TypeNameIdResolver._defaultTypeId(clazz);
            }
            this._typeToId.put(string, (String)object);
        }
        return object;
    }

    @Override
    public String idFromValueAndType(Object object, Class<?> clazz) {
        if (object == null) {
            return this.idFromClass(clazz);
        }
        return this.idFromValue(object);
    }

    @Override
    public JavaType typeFromId(DatabindContext databindContext, String string) {
        return this._typeFromId(string);
    }

    protected JavaType _typeFromId(String string) {
        if (this._caseInsensitive) {
            string = string.toLowerCase();
        }
        return this._idToType.get(string);
    }

    @Override
    public String getDescForKnownTypeIds() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Map.Entry<String, JavaType> entry : this._idToType.entrySet()) {
            if (!((ResolvedType)entry.getValue()).isConcrete()) continue;
            treeSet.add(entry.getKey());
        }
        return treeSet.toString();
    }

    public String toString() {
        return String.format("[%s; id-to-type=%s]", this.getClass().getName(), this._idToType);
    }

    protected static String _defaultTypeId(Class<?> object) {
        int n2 = ((String)(object = ((Class)object).getName())).lastIndexOf(46);
        if (n2 < 0) {
            return object;
        }
        return ((String)object).substring(n2 + 1);
    }
}

