/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo$As;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;

public abstract class TypeSerializerBase
extends TypeSerializer {
    protected final TypeIdResolver _idResolver;
    protected final BeanProperty _property;

    protected TypeSerializerBase(TypeIdResolver typeIdResolver, BeanProperty beanProperty) {
        this._idResolver = typeIdResolver;
        this._property = beanProperty;
    }

    @Override
    public abstract JsonTypeInfo$As getTypeInclusion();

    @Override
    public String getPropertyName() {
        return null;
    }

    @Override
    public TypeIdResolver getTypeIdResolver() {
        return this._idResolver;
    }

    @Override
    public WritableTypeId writeTypePrefix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) {
        this._generateTypeId(writableTypeId);
        return jsonGenerator.writeTypePrefix(writableTypeId);
    }

    @Override
    public WritableTypeId writeTypeSuffix(JsonGenerator jsonGenerator, WritableTypeId writableTypeId) {
        return jsonGenerator.writeTypeSuffix(writableTypeId);
    }

    protected void _generateTypeId(WritableTypeId writableTypeId) {
        Object object = writableTypeId.id;
        if (object == null) {
            object = writableTypeId.forValue;
            Class<?> clazz = writableTypeId.forValueType;
            object = clazz == null ? this.idFromValue(object) : this.idFromValueAndType(object, clazz);
            writableTypeId.id = object;
        }
    }

    protected String idFromValue(Object object) {
        String string = this._idResolver.idFromValue(object);
        if (string == null) {
            this.handleMissingId(object);
        }
        return string;
    }

    protected String idFromValueAndType(Object object, Class<?> object2) {
        if ((object2 = this._idResolver.idFromValueAndType(object, (Class<?>)object2)) == null) {
            this.handleMissingId(object);
        }
        return object2;
    }

    protected void handleMissingId(Object object) {
    }
}

