/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ValueNode;
import java.util.Arrays;

public class BinaryNode
extends ValueNode {
    private static final long serialVersionUID = 2L;
    static final BinaryNode EMPTY_BINARY_NODE = new BinaryNode(new byte[0]);
    protected final byte[] _data;

    public BinaryNode(byte[] byArray) {
        this._data = byArray;
    }

    public BinaryNode(byte[] byArray, int n2, int n3) {
        if (n2 == 0 && n3 == byArray.length) {
            this._data = byArray;
            return;
        }
        this._data = new byte[n3];
        System.arraycopy(byArray, n2, this._data, 0, n3);
    }

    public static BinaryNode valueOf(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(byArray);
    }

    public static BinaryNode valueOf(byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            return null;
        }
        if (n3 == 0) {
            return EMPTY_BINARY_NODE;
        }
        return new BinaryNode(byArray, n2, n3);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.BINARY;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_EMBEDDED_OBJECT;
    }

    @Override
    public byte[] binaryValue() {
        return this._data;
    }

    @Override
    public String asText() {
        return Base64Variants.getDefaultVariant().encode(this._data, false);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeBinary(serializerProvider.getConfig().getBase64Variant(), this._data, 0, this._data.length);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BinaryNode)) {
            return false;
        }
        return Arrays.equals(((BinaryNode)object)._data, this._data);
    }

    @Override
    public int hashCode() {
        if (this._data == null) {
            return -1;
        }
        return this._data.length;
    }
}

