/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.node;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.Base64Variants;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.NumberInput;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ValueNode;

public class TextNode
extends ValueNode {
    private static final long serialVersionUID = 2L;
    static final TextNode EMPTY_STRING_NODE = new TextNode("");
    protected final String _value;

    public TextNode(String string) {
        this._value = string;
    }

    public static TextNode valueOf(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return EMPTY_STRING_NODE;
        }
        return new TextNode(string);
    }

    @Override
    public JsonNodeType getNodeType() {
        return JsonNodeType.STRING;
    }

    @Override
    public JsonToken asToken() {
        return JsonToken.VALUE_STRING;
    }

    @Override
    public String textValue() {
        return this._value;
    }

    public byte[] getBinaryValue(Base64Variant base64Variant) {
        String string = this._value.trim();
        int n2 = 4 + (string.length() >> 2) * 3;
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(Math.max(16, Math.min(65536, n2)));
        try {
            base64Variant.decode(string, byteArrayBuilder);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw InvalidFormatException.from(null, String.format("Cannot access contents of TextNode as binary due to broken Base64 encoding: %s", illegalArgumentException.getMessage()), string, byte[].class);
        }
        return byteArrayBuilder.toByteArray();
    }

    @Override
    public byte[] binaryValue() {
        return this.getBinaryValue(Base64Variants.getDefaultVariant());
    }

    @Override
    public String asText() {
        return this._value;
    }

    @Override
    public String asText(String string) {
        if (this._value == null) {
            return string;
        }
        return this._value;
    }

    @Override
    public boolean asBoolean(boolean bl) {
        if (this._value != null) {
            String string = this._value.trim();
            if ("true".equals(string)) {
                return true;
            }
            if ("false".equals(string)) {
                return false;
            }
        }
        return bl;
    }

    @Override
    public int asInt(int n2) {
        return NumberInput.parseAsInt(this._value, n2);
    }

    @Override
    public long asLong(long l2) {
        return NumberInput.parseAsLong(this._value, l2);
    }

    @Override
    public double asDouble(double d2) {
        return NumberInput.parseAsDouble(this._value, d2);
    }

    @Override
    public final void serialize(JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._value == null) {
            jsonGenerator.writeNull();
            return;
        }
        jsonGenerator.writeString(this._value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof TextNode) {
            return ((TextNode)object)._value.equals(this._value);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this._value.hashCode();
    }

    @Deprecated
    protected static void appendQuoted(StringBuilder stringBuilder, String string) {
        stringBuilder.append('\"');
        CharTypes.appendQuoted(stringBuilder, string);
        stringBuilder.append('\"');
    }
}

