/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.JsonSerializer$None;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.cfg.HandlerInstantiator;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.fasterxml.jackson.databind.ser.impl.WritableObjectId;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DefaultSerializerProvider
extends SerializerProvider
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected transient Map<Object, WritableObjectId> _seenObjectIds;
    protected transient ArrayList<ObjectIdGenerator<?>> _objectIdGenerators;
    protected transient JsonGenerator _generator;

    protected DefaultSerializerProvider() {
    }

    protected DefaultSerializerProvider(SerializerProvider serializerProvider, SerializationConfig serializationConfig, SerializerFactory serializerFactory) {
        super(serializerProvider, serializationConfig, serializerFactory);
    }

    protected DefaultSerializerProvider(DefaultSerializerProvider defaultSerializerProvider) {
        super(defaultSerializerProvider);
    }

    public abstract DefaultSerializerProvider createInstance(SerializationConfig var1, SerializerFactory var2);

    public DefaultSerializerProvider copy() {
        throw new IllegalStateException("DefaultSerializerProvider sub-class not overriding copy()");
    }

    @Override
    public JsonSerializer<Object> serializerInstance(Annotated object, Object object2) {
        if (object2 == null) {
            return null;
        }
        if (object2 instanceof JsonSerializer) {
            object = (JsonSerializer)object2;
        } else {
            HandlerInstantiator handlerInstantiator;
            if (!(object2 instanceof Class)) {
                ((DatabindContext)this).reportBadDefinition(((Annotated)object).getType(), "AnnotationIntrospector returned serializer definition of type " + object2.getClass().getName() + "; expected type JsonSerializer or Class<JsonSerializer> instead");
            }
            if ((object2 = (Class)object2) == JsonSerializer$None.class || ClassUtil.isBogusClass(object2)) {
                return null;
            }
            if (!JsonSerializer.class.isAssignableFrom((Class<?>)object2)) {
                ((DatabindContext)this).reportBadDefinition(((Annotated)object).getType(), "AnnotationIntrospector returned Class " + ((Class)object2).getName() + "; expected Class<JsonSerializer>");
            }
            if ((object = (handlerInstantiator = this._config.getHandlerInstantiator()) == null ? null : handlerInstantiator.serializerInstance(this._config, (Annotated)object, (Class<?>)object2)) == null) {
                object = (JsonSerializer)ClassUtil.createInstance(object2, this._config.canOverrideAccessModifiers());
            }
        }
        return this._handleResolvable((JsonSerializer<?>)object);
    }

    @Override
    public Object includeFilterInstance(BeanPropertyDefinition object, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        HandlerInstantiator handlerInstantiator = this._config.getHandlerInstantiator();
        object = handlerInstantiator == null ? null : handlerInstantiator.includeFilterInstance(this._config, (BeanPropertyDefinition)object, clazz);
        if (object == null) {
            object = ClassUtil.createInstance(clazz, this._config.canOverrideAccessModifiers());
        }
        return object;
    }

    @Override
    public boolean includeFilterSuppressNulls(Object object) {
        if (object == null) {
            return true;
        }
        try {
            return object.equals(null);
        }
        catch (Throwable throwable) {
            String string = String.format("Problem determining whether filter of type '%s' should filter out `null` values: (%s) %s", object.getClass().getName(), throwable.getClass().getName(), ClassUtil.exceptionMessage(throwable));
            this.reportBadDefinition(object.getClass(), string, throwable);
            return false;
        }
    }

    @Override
    public WritableObjectId findObjectId(Object object, ObjectIdGenerator<?> objectIdGenerator) {
        Object object2;
        if (this._seenObjectIds == null) {
            this._seenObjectIds = this._createObjectIdMap();
        } else {
            object2 = this._seenObjectIds.get(object);
            if (object2 != null) {
                return object2;
            }
        }
        object2 = null;
        if (this._objectIdGenerators == null) {
            this._objectIdGenerators = new ArrayList(8);
        } else {
            int n2 = this._objectIdGenerators.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ObjectIdGenerator<?> objectIdGenerator2 = this._objectIdGenerators.get(i2);
                if (!objectIdGenerator2.canUseFor(objectIdGenerator)) continue;
                object2 = objectIdGenerator2;
                break;
            }
        }
        if (object2 == null) {
            object2 = objectIdGenerator.newForSerialization(this);
            this._objectIdGenerators.add((ObjectIdGenerator<?>)object2);
        }
        WritableObjectId writableObjectId = new WritableObjectId((ObjectIdGenerator<?>)object2);
        this._seenObjectIds.put(object, writableObjectId);
        return writableObjectId;
    }

    protected Map<Object, WritableObjectId> _createObjectIdMap() {
        if (this.isEnabled(SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID)) {
            return new HashMap<Object, WritableObjectId>();
        }
        return new IdentityHashMap<Object, WritableObjectId>();
    }

    public boolean hasSerializerFor(Class<?> object, AtomicReference<Throwable> atomicReference) {
        if (object == Object.class && !this._config.isEnabled(SerializationFeature.FAIL_ON_EMPTY_BEANS)) {
            return true;
        }
        try {
            object = this._findExplicitUntypedSerializer((Class<?>)object);
            return object != null;
        }
        catch (JsonMappingException jsonMappingException) {
            if (atomicReference != null) {
                atomicReference.set(jsonMappingException);
            }
        }
        catch (RuntimeException runtimeException) {
            if (atomicReference == null) {
                throw runtimeException;
            }
            atomicReference.set(runtimeException);
        }
        return false;
    }

    @Override
    public JsonGenerator getGenerator() {
        return this._generator;
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object) {
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        Class<?> clazz = object.getClass();
        JsonSerializer<Object> jsonSerializer = this.findTypedValueSerializer(clazz, true, null);
        PropertyName propertyName = this._config.getFullRootName();
        if (propertyName == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                this._serialize(jsonGenerator, object, jsonSerializer, ((MapperConfig)this._config).findRootName(clazz));
                return;
            }
        } else if (!propertyName.isEmpty()) {
            this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        this._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType) {
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (!((ResolvedType)javaType).getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        JsonSerializer<Object> jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        PropertyName propertyName = this._config.getFullRootName();
        if (propertyName == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                this._serialize(jsonGenerator, object, jsonSerializer, ((MapperConfig)this._config).findRootName(javaType));
                return;
            }
        } else if (!propertyName.isEmpty()) {
            this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        this._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializeValue(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer) {
        PropertyName propertyName;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (javaType != null && !((ResolvedType)javaType).getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if (jsonSerializer == null) {
            jsonSerializer = this.findTypedValueSerializer(javaType, true, null);
        }
        if ((propertyName = this._config.getFullRootName()) == null) {
            if (this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE)) {
                propertyName = javaType == null ? ((MapperConfig)this._config).findRootName(object.getClass()) : ((MapperConfig)this._config).findRootName(javaType);
                this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
                return;
            }
        } else if (!propertyName.isEmpty()) {
            this._serialize(jsonGenerator, object, jsonSerializer, propertyName);
            return;
        }
        this._serialize(jsonGenerator, object, jsonSerializer);
    }

    public void serializePolymorphic(JsonGenerator jsonGenerator, Object object, JavaType javaType, JsonSerializer<Object> jsonSerializer, TypeSerializer typeSerializer) {
        boolean bl;
        PropertyName propertyName;
        this._generator = jsonGenerator;
        if (object == null) {
            this._serializeNull(jsonGenerator);
            return;
        }
        if (javaType != null && !((ResolvedType)javaType).getRawClass().isAssignableFrom(object.getClass())) {
            this._reportIncompatibleRootType(object, javaType);
        }
        if (jsonSerializer == null) {
            jsonSerializer = javaType != null && ((ResolvedType)javaType).isContainerType() ? this.findValueSerializer(javaType, null) : this.findValueSerializer(object.getClass(), null);
        }
        if ((propertyName = this._config.getFullRootName()) == null) {
            bl = this._config.isEnabled(SerializationFeature.WRAP_ROOT_VALUE);
            if (bl) {
                jsonGenerator.writeStartObject();
                propertyName = ((MapperConfig)this._config).findRootName(object.getClass());
                jsonGenerator.writeFieldName(propertyName.simpleAsEncoded(this._config));
            }
        } else if (propertyName.isEmpty()) {
            bl = false;
        } else {
            bl = true;
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.getSimpleName());
        }
        try {
            jsonSerializer.serializeWithType(object, jsonGenerator, this, typeSerializer);
            if (bl) {
                jsonGenerator.writeEndObject();
            }
            return;
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    private final void _serialize(JsonGenerator jsonGenerator, Object object, JsonSerializer<Object> jsonSerializer, PropertyName propertyName) {
        try {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeFieldName(propertyName.simpleAsEncoded(this._config));
            jsonSerializer.serialize(object, jsonGenerator, this);
            jsonGenerator.writeEndObject();
            return;
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    private final void _serialize(JsonGenerator jsonGenerator, Object object, JsonSerializer<Object> jsonSerializer) {
        try {
            jsonSerializer.serialize(object, jsonGenerator, this);
            return;
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    protected void _serializeNull(JsonGenerator jsonGenerator) {
        JsonSerializer<Object> jsonSerializer = this.getDefaultNullValueSerializer();
        try {
            jsonSerializer.serialize(null, jsonGenerator, this);
            return;
        }
        catch (Exception exception) {
            throw this._wrapAsIOE(jsonGenerator, exception);
        }
    }

    private IOException _wrapAsIOE(JsonGenerator jsonGenerator, Exception exception) {
        if (exception instanceof IOException) {
            return (IOException)exception;
        }
        String string = ClassUtil.exceptionMessage(exception);
        if (string == null) {
            string = "[no message for " + exception.getClass().getName() + "]";
        }
        return new JsonMappingException((Closeable)jsonGenerator, string, (Throwable)exception);
    }

    public int cachedSerializersCount() {
        return this._serializerCache.size();
    }

    public void flushCachedSerializers() {
        this._serializerCache.flush();
    }

    public void acceptJsonFormatVisitor(JavaType javaType, JsonFormatVisitorWrapper jsonFormatVisitorWrapper) {
        if (javaType == null) {
            throw new IllegalArgumentException("A class must be provided");
        }
        jsonFormatVisitorWrapper.setProvider(this);
        this.findValueSerializer(javaType, null).acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType);
    }

    @Deprecated
    public JsonSchema generateJsonSchema(Class<?> clazz) {
        JsonSerializer<Object> jsonSerializer = this.findValueSerializer(clazz, null);
        jsonSerializer = jsonSerializer instanceof SchemaAware ? ((SchemaAware)((Object)jsonSerializer)).getSchema(this, null) : JsonSchema.getDefaultSchemaNode();
        if (!(jsonSerializer instanceof ObjectNode)) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " would not be serialized as a JSON object and therefore has no schema");
        }
        return new JsonSchema((ObjectNode)((Object)jsonSerializer));
    }
}

