/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser;

import com.fasterxml.jackson.annotation.JsonInclude$Include;
import com.fasterxml.jackson.annotation.JsonInclude$Value;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize$Typing;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyBuilder$1;
import com.fasterxml.jackson.databind.util.Annotations;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.BeanUtil;
import com.fasterxml.jackson.databind.util.ClassUtil;
import com.fasterxml.jackson.databind.util.NameTransformer;

public class PropertyBuilder {
    private static final Object NO_DEFAULT_MARKER = Boolean.FALSE;
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;
    protected final JsonInclude$Value _defaultInclusion;
    protected final boolean _useRealPropertyDefaults;

    public PropertyBuilder(SerializationConfig serializationConfig, BeanDescription object) {
        this._config = serializationConfig;
        this._beanDesc = object;
        object = JsonInclude$Value.merge(((BeanDescription)object).findPropertyInclusion(JsonInclude$Value.empty()), serializationConfig.getDefaultPropertyInclusion(((BeanDescription)object).getBeanClass(), JsonInclude$Value.empty()));
        this._defaultInclusion = JsonInclude$Value.merge(((MapperConfig)serializationConfig).getDefaultPropertyInclusion(), (JsonInclude$Value)object);
        this._useRealPropertyDefaults = ((JsonInclude$Value)object).getValueInclusion() == JsonInclude$Include.NON_DEFAULT;
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    protected BeanPropertyWriter buildWriter(SerializerProvider object, BeanPropertyDefinition object2, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, TypeSerializer typeSerializer2, AnnotatedMember annotatedMember, boolean bl) {
        Object object3;
        JavaType javaType2;
        try {
            javaType2 = this.findSerializationType(annotatedMember, bl, javaType);
        }
        catch (JsonMappingException jsonMappingException) {
            if (object2 == null) {
                return (BeanPropertyWriter)((DatabindContext)object).reportBadDefinition(javaType, ClassUtil.exceptionMessage(jsonMappingException));
            }
            return (BeanPropertyWriter)((SerializerProvider)object).reportBadPropertyDefinition(this._beanDesc, (BeanPropertyDefinition)object2, ClassUtil.exceptionMessage(jsonMappingException), new Object[0]);
        }
        if (typeSerializer2 != null) {
            if (javaType2 == null) {
                javaType2 = javaType;
            }
            if ((object3 = javaType2.getContentType()) == null) {
                ((SerializerProvider)object).reportBadPropertyDefinition(this._beanDesc, (BeanPropertyDefinition)object2, "serialization type " + javaType2 + " has no content", new Object[0]);
            }
            javaType2 = javaType2.withContentTypeHandler(typeSerializer2);
            javaType2.getContentType();
        }
        object3 = null;
        boolean bl2 = false;
        JavaType javaType3 = javaType2 == null ? javaType : javaType2;
        Object object4 = ((BeanPropertyDefinition)object2).getAccessor();
        if (object4 == null) {
            return (BeanPropertyWriter)((SerializerProvider)object).reportBadPropertyDefinition(this._beanDesc, (BeanPropertyDefinition)object2, "could not determine property type", new Object[0]);
        }
        object4 = object4.getRawType();
        object4 = this._config.getDefaultInclusion(((ResolvedType)javaType3).getRawClass(), (Class<?>)object4, this._defaultInclusion);
        Object object5 = (object4 = object4.withOverrides(((BeanPropertyDefinition)object2).findInclusion())).getValueInclusion();
        if (object5 == JsonInclude$Include.USE_DEFAULTS) {
            object5 = JsonInclude$Include.ALWAYS;
        }
        switch (PropertyBuilder$1.$SwitchMap$com$fasterxml$jackson$annotation$JsonInclude$Include[((Enum)object5).ordinal()]) {
            case 1: {
                if (this._useRealPropertyDefaults && (object4 = this.getDefaultBean()) != null) {
                    if (((DatabindContext)object).isEnabled(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS)) {
                        annotatedMember.fixAccess(this._config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
                    }
                    try {
                        object3 = annotatedMember.getValue(object4);
                    }
                    catch (Exception exception) {
                        this._throwWrapped(exception, ((BeanPropertyDefinition)object2).getName(), object4);
                    }
                } else {
                    object3 = BeanUtil.getDefaultValue(javaType3);
                    bl2 = true;
                }
                if (object3 == null) {
                    bl2 = true;
                    break;
                }
                if (!object3.getClass().isArray()) break;
                object3 = ArrayBuilders.getArrayComparator(object3);
                break;
            }
            case 2: {
                bl2 = true;
                if (!javaType3.isReferenceType()) break;
                object3 = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case 3: {
                bl2 = true;
                object3 = BeanPropertyWriter.MARKER_FOR_EMPTY;
                break;
            }
            case 4: {
                object3 = ((SerializerProvider)object).includeFilterInstance((BeanPropertyDefinition)object2, object4.getValueFilter());
                if (object3 == null) {
                    bl2 = true;
                    break;
                }
                bl2 = ((SerializerProvider)object).includeFilterSuppressNulls(object3);
                break;
            }
            case 5: {
                bl2 = true;
            }
            default: {
                object5 = SerializationFeature.WRITE_EMPTY_JSON_ARRAYS;
                if (!((ResolvedType)javaType3).isContainerType() || this._config.isEnabled((SerializationFeature)object5)) break;
                object3 = BeanPropertyWriter.MARKER_FOR_EMPTY;
            }
        }
        object4 = ((BeanPropertyDefinition)object2).findViews();
        if (object4 == null) {
            object4 = this._beanDesc.findDefaultViews();
        }
        object5 = this._constructPropertyWriter((BeanPropertyDefinition)object2, annotatedMember, this._beanDesc.getClassAnnotations(), javaType, jsonSerializer, typeSerializer, javaType2, bl2, object3, (Class<?>[])object4);
        object2 = this._annotationIntrospector.findNullSerializer(annotatedMember);
        if (object2 != null) {
            ((BeanPropertyWriter)object5).assignNullSerializer(((SerializerProvider)object).serializerInstance(annotatedMember, object2));
        }
        if ((object = this._annotationIntrospector.findUnwrappingNameTransformer(annotatedMember)) != null) {
            object5 = ((BeanPropertyWriter)object5).unwrappingWriter((NameTransformer)object);
        }
        return object5;
    }

    protected BeanPropertyWriter _constructPropertyWriter(BeanPropertyDefinition beanPropertyDefinition, AnnotatedMember annotatedMember, Annotations annotations, JavaType javaType, JsonSerializer<?> jsonSerializer, TypeSerializer typeSerializer, JavaType javaType2, boolean bl, Object object, Class<?>[] classArray) {
        return new BeanPropertyWriter(beanPropertyDefinition, annotatedMember, annotations, javaType, jsonSerializer, typeSerializer, javaType2, bl, object, classArray);
    }

    protected JavaType findSerializationType(Annotated annotated, boolean bl, JavaType javaType) {
        Object object;
        JavaType javaType2 = this._annotationIntrospector.refineSerializationType(this._config, annotated, javaType);
        if (javaType2 != javaType) {
            Class<?> clazz;
            object = ((ResolvedType)javaType2).getRawClass();
            if (!((Class)object).isAssignableFrom(clazz = ((ResolvedType)javaType).getRawClass()) && !clazz.isAssignableFrom((Class<?>)object)) {
                throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + annotated.getName() + "': class " + ((Class)object).getName() + " not a super-type of (declared) class " + clazz.getName());
            }
            bl = true;
            javaType = javaType2;
        }
        if ((object = this._annotationIntrospector.findSerializationTyping(annotated)) != null && object != JsonSerialize$Typing.DEFAULT_TYPING) {
            boolean bl2 = bl = object == JsonSerialize$Typing.STATIC;
        }
        if (bl) {
            return javaType.withStaticTyping();
        }
        return null;
    }

    protected Object getDefaultBean() {
        Object object = this._defaultBean;
        if (object == null) {
            object = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (object == null) {
                object = NO_DEFAULT_MARKER;
            }
            this._defaultBean = object;
        }
        if (object == NO_DEFAULT_MARKER) {
            return null;
        }
        return this._defaultBean;
    }

    @Deprecated
    protected Object getPropertyDefaultValue(String string, AnnotatedMember annotatedMember, JavaType javaType) {
        Object object = this.getDefaultBean();
        if (object == null) {
            return this.getDefaultValue(javaType);
        }
        try {
            return annotatedMember.getValue(object);
        }
        catch (Exception exception) {
            return this._throwWrapped(exception, string, object);
        }
    }

    @Deprecated
    protected Object getDefaultValue(JavaType javaType) {
        return BeanUtil.getDefaultValue(javaType);
    }

    protected Object _throwWrapped(Exception throwable, String string, Object object) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        ClassUtil.throwIfError(throwable);
        ClassUtil.throwIfRTE(throwable);
        throw new IllegalArgumentException("Failed to get property '" + string + "' of default " + object.getClass().getName() + " instance");
    }
}

