/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.ObjectIdWriter;
import com.fasterxml.jackson.databind.ser.std.BeanSerializerBase;
import com.fasterxml.jackson.databind.util.NameTransformer;
import java.util.Set;

public class BeanAsArraySerializer
extends BeanSerializerBase {
    private static final long serialVersionUID = 1L;
    protected final BeanSerializerBase _defaultSerializer;

    public BeanAsArraySerializer(BeanSerializerBase beanSerializerBase) {
        super(beanSerializerBase, (ObjectIdWriter)null);
        this._defaultSerializer = beanSerializerBase;
    }

    protected BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, Set<String> set) {
        this(beanSerializerBase, set, null);
    }

    protected BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, Set<String> set, Set<String> set2) {
        super(beanSerializerBase, set, set2);
        this._defaultSerializer = beanSerializerBase;
    }

    protected BeanAsArraySerializer(BeanSerializerBase beanSerializerBase, ObjectIdWriter objectIdWriter, Object object) {
        super(beanSerializerBase, objectIdWriter, object);
        this._defaultSerializer = beanSerializerBase;
    }

    @Override
    public JsonSerializer<Object> unwrappingSerializer(NameTransformer nameTransformer) {
        return this._defaultSerializer.unwrappingSerializer(nameTransformer);
    }

    @Override
    public boolean isUnwrappingSerializer() {
        return false;
    }

    @Override
    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return this._defaultSerializer.withObjectIdWriter(objectIdWriter);
    }

    @Override
    public BeanSerializerBase withFilterId(Object object) {
        BeanAsArraySerializer beanAsArraySerializer = this;
        return new BeanAsArraySerializer((BeanSerializerBase)beanAsArraySerializer, beanAsArraySerializer._objectIdWriter, object);
    }

    @Override
    protected BeanAsArraySerializer withByNameInclusion(Set<String> set, Set<String> set2) {
        return new BeanAsArraySerializer((BeanSerializerBase)this, set, set2);
    }

    @Override
    public BeanSerializerBase withProperties(BeanPropertyWriter[] beanPropertyWriterArray, BeanPropertyWriter[] beanPropertyWriterArray2) {
        return this;
    }

    @Override
    public BeanSerializerBase asArraySerializer() {
        return this;
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(object, jsonGenerator, serializerProvider, typeSerializer);
            return;
        }
        WritableTypeId writableTypeId = this._typeIdDef(typeSerializer, object, JsonToken.START_ARRAY);
        typeSerializer.writeTypePrefix(jsonGenerator, writableTypeId);
        jsonGenerator.setCurrentValue(object);
        this.serializeAsArray(object, jsonGenerator, serializerProvider);
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    @Override
    public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) && this.hasSingleElement(serializerProvider)) {
            this.serializeAsArray(object, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(object);
        this.serializeAsArray(object, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    private boolean hasSingleElement(SerializerProvider beanPropertyWriterArray) {
        beanPropertyWriterArray = this._filteredProps != null && beanPropertyWriterArray.getActiveView() != null ? this._filteredProps : this._props;
        return beanPropertyWriterArray.length == 1;
    }

    protected final void serializeAsArray(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2;
        BeanPropertyWriter[] beanPropertyWriterArray = this._filteredProps != null && ((DatabindContext)serializerProvider).getActiveView() != null ? this._filteredProps : this._props;
        try {
            for (BeanPropertyWriter beanPropertyWriter : beanPropertyWriterArray) {
                if (beanPropertyWriter == null) {
                    jsonGenerator.writeNull();
                    continue;
                }
                ((PropertyWriter)beanPropertyWriter).serializeAsElement(object, jsonGenerator, serializerProvider);
            }
            return;
        }
        catch (Exception exception) {
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, ((PropertyWriter)beanPropertyWriterArray[n2]).getName());
            return;
        }
        catch (StackOverflowError stackOverflowError) {
            JsonMappingException jsonMappingException = JsonMappingException.from(jsonGenerator, "Infinite recursion (StackOverflowError)", (Throwable)stackOverflowError);
            ((DatabindException)jsonMappingException).prependPath(object, ((PropertyWriter)beanPropertyWriterArray[n2]).getName());
            throw jsonMappingException;
        }
    }

    public String toString() {
        return "BeanAsArraySerializer for " + ((JsonSerializer)this).handledType().getName();
    }
}

