/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.impl;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;
import java.util.Iterator;

@JacksonStdImpl
public class IteratorSerializer
extends AsArraySerializerBase<Iterator<?>> {
    public IteratorSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer) {
        super(Iterator.class, javaType, bl, typeSerializer, null);
    }

    public IteratorSerializer(IteratorSerializer iteratorSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        super(iteratorSerializer, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Iterator<?> iterator) {
        return !iterator.hasNext();
    }

    @Override
    public boolean hasSingleElement(Iterator<?> iterator) {
        return false;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        IteratorSerializer iteratorSerializer = this;
        return new IteratorSerializer(iteratorSerializer, iteratorSerializer._property, typeSerializer, this._elementSerializer, this._unwrapSingle);
    }

    public IteratorSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        return new IteratorSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public final void serialize(Iterator<?> iterator, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        jsonGenerator.writeStartArray(iterator);
        this.serializeContents(iterator, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(Iterator<?> iterator, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (!iterator.hasNext()) {
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._elementSerializer;
        if (jsonSerializer == null) {
            this._serializeDynamicContents(iterator, jsonGenerator, serializerProvider);
            return;
        }
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        do {
            Object obj;
            if ((obj = iterator.next()) == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            if (typeSerializer == null) {
                jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                continue;
            }
            jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
        } while (iterator.hasNext());
    }

    protected void _serializeDynamicContents(Iterator<?> iterator, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        PropertySerializerMap propertySerializerMap = this._dynamicSerializers;
        do {
            Object obj;
            if ((obj = iterator.next()) == null) {
                serializerProvider.defaultSerializeNull(jsonGenerator);
                continue;
            }
            Class<?> clazz = obj.getClass();
            JsonSerializer<Object> jsonSerializer = propertySerializerMap.serializerFor(clazz);
            if (jsonSerializer == null) {
                jsonSerializer = ((ResolvedType)this._elementType).hasGenericTypes() ? this._findAndAddDynamic(propertySerializerMap, ((DatabindContext)serializerProvider).constructSpecializedType(this._elementType, clazz), serializerProvider) : this._findAndAddDynamic(propertySerializerMap, clazz, serializerProvider);
                propertySerializerMap = this._dynamicSerializers;
            }
            if (typeSerializer == null) {
                jsonSerializer.serialize(obj, jsonGenerator, serializerProvider);
                continue;
            }
            jsonSerializer.serializeWithType(obj, jsonGenerator, serializerProvider, typeSerializer);
        } while (iterator.hasNext());
    }
}

