/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.ser.std.DateTimeSerializerBase;
import java.text.DateFormat;
import java.util.Date;

@JacksonStdImpl
public class DateSerializer
extends DateTimeSerializerBase<Date> {
    public static final DateSerializer instance = new DateSerializer();

    public DateSerializer() {
        this(null, null);
    }

    public DateSerializer(Boolean bl, DateFormat dateFormat) {
        super(Date.class, bl, dateFormat);
    }

    public DateSerializer withFormat(Boolean bl, DateFormat dateFormat) {
        return new DateSerializer(bl, dateFormat);
    }

    @Override
    protected long _timestamp(Date date) {
        if (date == null) {
            return 0L;
        }
        return date.getTime();
    }

    @Override
    public void serialize(Date date, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (this._asTimestamp(serializerProvider)) {
            jsonGenerator.writeNumber(this._timestamp(date));
            return;
        }
        this._serializeAsString(date, jsonGenerator, serializerProvider);
    }
}

