/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Shape;
import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final Boolean _useTimestamp;
    protected final DateFormat _customFormat;
    protected final AtomicReference<DateFormat> _reusedCustomFormat;

    protected DateTimeSerializerBase(Class<T> clazz, Boolean bl, DateFormat dateFormat) {
        super(clazz);
        this._useTimestamp = bl;
        this._customFormat = dateFormat;
        this._reusedCustomFormat = dateFormat == null ? null : new AtomicReference();
    }

    public abstract DateTimeSerializerBase<T> withFormat(Boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty object2) {
        boolean bl;
        if ((object2 = this.findFormatOverrides((SerializerProvider)object, (BeanProperty)object2, ((JsonSerializer)this).handledType())) == null) {
            return this;
        }
        Object object3 = ((JsonFormat$Value)object2).getShape();
        if (object3.isNumeric()) {
            return this.withFormat(Boolean.TRUE, null);
        }
        if (((JsonFormat$Value)object2).hasPattern()) {
            Locale locale = ((JsonFormat$Value)object2).hasLocale() ? ((JsonFormat$Value)object2).getLocale() : ((DatabindContext)object).getLocale();
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(((JsonFormat$Value)object2).getPattern(), locale);
            object3 = ((JsonFormat$Value)object2).hasTimeZone() ? ((JsonFormat$Value)object2).getTimeZone() : ((DatabindContext)object).getTimeZone();
            simpleDateFormat.setTimeZone((TimeZone)object3);
            return this.withFormat(Boolean.FALSE, simpleDateFormat);
        }
        boolean bl2 = ((JsonFormat$Value)object2).hasLocale();
        boolean bl3 = ((JsonFormat$Value)object2).hasTimeZone();
        boolean bl4 = bl = object3 == JsonFormat$Shape.STRING;
        if (!(bl2 || bl3 || bl)) {
            return this;
        }
        DateFormat dateFormat = ((SerializerProvider)object).getConfig().getDateFormat();
        if (dateFormat instanceof StdDateFormat) {
            object = (StdDateFormat)dateFormat;
            if (((JsonFormat$Value)object2).hasLocale()) {
                object = ((StdDateFormat)object).withLocale(((JsonFormat$Value)object2).getLocale());
            }
            if (((JsonFormat$Value)object2).hasTimeZone()) {
                object = ((StdDateFormat)object).withTimeZone(((JsonFormat$Value)object2).getTimeZone());
            }
            return this.withFormat(Boolean.FALSE, (DateFormat)object);
        }
        if (!(dateFormat instanceof SimpleDateFormat)) {
            ((DatabindContext)object).reportBadDefinition(((JsonSerializer)this).handledType(), String.format("Configured `DateFormat` (%s) not a `SimpleDateFormat`; cannot configure `Locale` or `TimeZone`", dateFormat.getClass().getName()));
        }
        object = (SimpleDateFormat)dateFormat;
        object = bl2 ? new SimpleDateFormat(((SimpleDateFormat)object).toPattern(), ((JsonFormat$Value)object2).getLocale()) : (SimpleDateFormat)((SimpleDateFormat)object).clone();
        boolean bl5 = (object2 = ((JsonFormat$Value)object2).getTimeZone()) != null && !object2.equals(((DateFormat)object).getTimeZone());
        if (bl5) {
            ((DateFormat)object).setTimeZone((TimeZone)object2);
        }
        return this.withFormat(Boolean.FALSE, (DateFormat)object);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, T t2) {
        return false;
    }

    protected abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        DateTimeSerializerBase dateTimeSerializerBase = this;
        return dateTimeSerializerBase.createSchemaNode(dateTimeSerializerBase._asTimestamp(serializerProvider) ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        this._acceptJsonFormatVisitor(jsonFormatVisitorWrapper, javaType, this._asTimestamp(jsonFormatVisitorWrapper.getProvider()));
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3);

    protected boolean _asTimestamp(SerializerProvider serializerProvider) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        if (this._customFormat == null) {
            if (serializerProvider != null) {
                return serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            }
            throw new IllegalArgumentException("Null SerializerProvider passed for " + ((JsonSerializer)this).handledType().getName());
        }
        return false;
    }

    protected void _acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType, boolean bl) {
        if (bl) {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser$NumberType.LONG, JsonValueFormat.UTC_MILLISEC);
            return;
        }
        this.visitStringFormat(jsonFormatVisitorWrapper, javaType, JsonValueFormat.DATE_TIME);
    }

    protected void _serializeAsString(Date date, JsonGenerator jsonGenerator, SerializerProvider object) {
        if (this._customFormat == null) {
            ((SerializerProvider)object).defaultSerializeDateValue(date, jsonGenerator);
            return;
        }
        object = this._reusedCustomFormat.getAndSet(null);
        if (object == null) {
            object = (DateFormat)this._customFormat.clone();
        }
        jsonGenerator.writeString(((DateFormat)object).format(date));
        this._reusedCustomFormat.compareAndSet(null, (DateFormat)object);
    }
}

