/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.std.AsArraySerializerBase;

@JacksonStdImpl
public class IterableSerializer
extends AsArraySerializerBase<Iterable<?>> {
    public IterableSerializer(JavaType javaType, boolean bl, TypeSerializer typeSerializer) {
        super(Iterable.class, javaType, bl, typeSerializer, null);
    }

    public IterableSerializer(IterableSerializer iterableSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        super(iterableSerializer, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        IterableSerializer iterableSerializer = this;
        return new IterableSerializer(iterableSerializer, iterableSerializer._property, typeSerializer, this._elementSerializer, this._unwrapSingle);
    }

    public IterableSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, Boolean bl) {
        return new IterableSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Iterable<?> iterable) {
        return !iterable.iterator().hasNext();
    }

    @Override
    public boolean hasSingleElement(Iterable<?> object) {
        if (object != null && (object = object.iterator()).hasNext()) {
            object.next();
            if (!object.hasNext()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final void serialize(Iterable<?> iterable, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if ((this._unwrapSingle == null && serializerProvider.isEnabled(SerializationFeature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED) || this._unwrapSingle == Boolean.TRUE) && this.hasSingleElement(iterable)) {
            this.serializeContents(iterable, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(iterable);
        this.serializeContents(iterable, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(Iterable<?> object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if ((object = object.iterator()).hasNext()) {
            TypeSerializer typeSerializer = this._valueTypeSerializer;
            JsonSerializer<Object> jsonSerializer = null;
            Class<?> clazz = null;
            do {
                Object e2;
                if ((e2 = object.next()) == null) {
                    serializerProvider.defaultSerializeNull(jsonGenerator);
                    continue;
                }
                JsonSerializer<Object> jsonSerializer2 = this._elementSerializer;
                if (jsonSerializer2 == null) {
                    Class<?> clazz2 = e2.getClass();
                    if (clazz2 == clazz) {
                        jsonSerializer2 = jsonSerializer;
                    } else {
                        jsonSerializer2 = serializerProvider.findValueSerializer(clazz2, this._property);
                        jsonSerializer = jsonSerializer2;
                        clazz = clazz2;
                    }
                }
                if (typeSerializer == null) {
                    jsonSerializer2.serialize(e2, jsonGenerator, serializerProvider);
                    continue;
                }
                jsonSerializer2.serializeWithType(e2, jsonGenerator, serializerProvider, typeSerializer);
            } while (object.hasNext());
        }
    }
}

