/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.RuntimeJsonMappingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap$SerializerAndMapResult;
import com.fasterxml.jackson.databind.ser.std.JsonValueSerializer$TypeSerializerRerouter;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;

@JacksonStdImpl
public class JsonValueSerializer
extends StdSerializer<Object>
implements JsonFormatVisitable,
SchemaAware,
ContextualSerializer {
    protected final AnnotatedMember _accessor;
    protected final TypeSerializer _valueTypeSerializer;
    protected final JsonSerializer<Object> _valueSerializer;
    protected final BeanProperty _property;
    protected final JavaType _valueType;
    protected final boolean _forceTypeInformation;
    protected transient PropertySerializerMap _dynamicSerializers;

    public JsonValueSerializer(AnnotatedMember annotatedMember, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer) {
        super(annotatedMember.getType());
        this._accessor = annotatedMember;
        this._valueType = annotatedMember.getType();
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._property = null;
        this._forceTypeInformation = true;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    @Deprecated
    public JsonValueSerializer(AnnotatedMember annotatedMember, JsonSerializer<?> jsonSerializer) {
        this(annotatedMember, null, jsonSerializer);
    }

    public JsonValueSerializer(JsonValueSerializer jsonValueSerializer, BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, boolean bl) {
        super(JsonValueSerializer._notNullClass(((JsonSerializer)jsonValueSerializer).handledType()));
        this._accessor = jsonValueSerializer._accessor;
        this._valueType = jsonValueSerializer._valueType;
        this._valueTypeSerializer = typeSerializer;
        this._valueSerializer = jsonSerializer;
        this._property = beanProperty;
        this._forceTypeInformation = bl;
        this._dynamicSerializers = PropertySerializerMap.emptyForProperties();
    }

    private static final Class<Object> _notNullClass(Class<?> clazz) {
        if (clazz == null) {
            return Object.class;
        }
        return clazz;
    }

    protected JsonValueSerializer withResolved(BeanProperty beanProperty, TypeSerializer typeSerializer, JsonSerializer<?> jsonSerializer, boolean bl) {
        if (this._property == beanProperty && this._valueTypeSerializer == typeSerializer && this._valueSerializer == jsonSerializer && bl == this._forceTypeInformation) {
            return this;
        }
        return new JsonValueSerializer(this, beanProperty, typeSerializer, jsonSerializer, bl);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, Object object) {
        if ((object = this._accessor.getValue(object)) == null) {
            return true;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            try {
                jsonSerializer = this._findDynamicSerializer(serializerProvider, object.getClass());
            }
            catch (JsonMappingException jsonMappingException) {
                throw new RuntimeJsonMappingException(jsonMappingException);
            }
        }
        return jsonSerializer.isEmpty(serializerProvider, object);
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        JsonSerializer<Object> jsonSerializer;
        TypeSerializer typeSerializer = this._valueTypeSerializer;
        if (typeSerializer != null) {
            typeSerializer = typeSerializer.forProperty(beanProperty);
        }
        if ((jsonSerializer = this._valueSerializer) == null) {
            if (((DatabindContext)serializerProvider).isEnabled(MapperFeature.USE_STATIC_TYPING) || ((ResolvedType)this._valueType).isFinal()) {
                jsonSerializer = serializerProvider.findPrimaryPropertySerializer(this._valueType, beanProperty);
                JsonValueSerializer jsonValueSerializer = this;
                boolean bl = jsonValueSerializer.isNaturalTypeWithStdHandling(((ResolvedType)jsonValueSerializer._valueType).getRawClass(), jsonSerializer);
                return this.withResolved(beanProperty, typeSerializer, jsonSerializer, bl);
            }
            if (beanProperty != this._property) {
                return this.withResolved(beanProperty, typeSerializer, jsonSerializer, this._forceTypeInformation);
            }
        } else {
            jsonSerializer = serializerProvider.handlePrimaryContextualization(jsonSerializer, beanProperty);
            return this.withResolved(beanProperty, typeSerializer, jsonSerializer, this._forceTypeInformation);
        }
        return this;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        Object object2;
        try {
            object2 = this._accessor.getValue(object);
        }
        catch (Exception exception) {
            object2 = null;
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, this._accessor.getName() + "()");
        }
        if (object2 == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findDynamicSerializer(serializerProvider, object2.getClass());
        }
        if (this._valueTypeSerializer != null) {
            jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, this._valueTypeSerializer);
            return;
        }
        jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
    }

    @Override
    public void serializeWithType(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        Object object2;
        try {
            object2 = this._accessor.getValue(object);
        }
        catch (Exception exception) {
            object2 = null;
            this.wrapAndThrow(serializerProvider, (Throwable)exception, object, this._accessor.getName() + "()");
        }
        if (object2 == null) {
            serializerProvider.defaultSerializeNull(jsonGenerator);
            return;
        }
        JsonSerializer<Object> jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null) {
            jsonSerializer = this._findDynamicSerializer(serializerProvider, object2.getClass());
        } else if (this._forceTypeInformation) {
            object = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(object, JsonToken.VALUE_STRING));
            jsonSerializer.serialize(object2, jsonGenerator, serializerProvider);
            typeSerializer.writeTypeSuffix(jsonGenerator, (WritableTypeId)object);
            return;
        }
        object = new JsonValueSerializer$TypeSerializerRerouter(typeSerializer, object);
        jsonSerializer.serializeWithType(object2, jsonGenerator, serializerProvider, (TypeSerializer)object);
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        if (this._valueSerializer instanceof SchemaAware) {
            return ((SchemaAware)((Object)this._valueSerializer)).getSchema(serializerProvider, null);
        }
        return JsonSchema.getDefaultSchemaNode();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        JsonSerializer<Object> jsonSerializer = this._accessor.getDeclaringClass();
        if (jsonSerializer != null && ClassUtil.isEnumType(jsonSerializer) && this._acceptJsonFormatVisitorForEnum(jsonFormatVisitorWrapper, javaType, (Class<?>)((Object)jsonSerializer))) {
            return;
        }
        jsonSerializer = this._valueSerializer;
        if (jsonSerializer == null && (jsonSerializer = jsonFormatVisitorWrapper.getProvider().findTypedValueSerializer(this._valueType, false, this._property)) == null) {
            jsonFormatVisitorWrapper.expectAnyFormat(javaType);
            return;
        }
        jsonSerializer.acceptJsonFormatVisitor(jsonFormatVisitorWrapper, this._valueType);
    }

    protected boolean _acceptJsonFormatVisitorForEnum(JsonFormatVisitorWrapper object, JavaType serializable, Class<?> objArray) {
        if ((object = object.expectStringFormat((JavaType)serializable)) != null) {
            serializable = new LinkedHashSet();
            for (Object obj : objArray.getEnumConstants()) {
                try {
                    serializable.add(String.valueOf(this._accessor.getValue(obj)));
                }
                catch (Exception exception) {
                    object = exception;
                    object = exception;
                    while (object instanceof InvocationTargetException && ((Throwable)object).getCause() != null) {
                        object = ((Throwable)object).getCause();
                    }
                    ClassUtil.throwIfError((Throwable)object);
                    throw JsonMappingException.wrapWithPath((Throwable)object, obj, this._accessor.getName() + "()");
                }
            }
            object.enumTypes((Set<String>)((Object)serializable));
        }
        return true;
    }

    protected boolean isNaturalTypeWithStdHandling(Class<?> clazz, JsonSerializer<?> jsonSerializer) {
        if (clazz.isPrimitive() ? clazz != Integer.TYPE && clazz != Boolean.TYPE && clazz != Double.TYPE : clazz != String.class && clazz != Integer.class && clazz != Boolean.class && clazz != Double.class) {
            return false;
        }
        return this.isDefaultSerializer(jsonSerializer);
    }

    protected JsonSerializer<Object> _findDynamicSerializer(SerializerProvider object, Class<?> object2) {
        JsonSerializer<Object> jsonSerializer = this._dynamicSerializers.serializerFor((Class<?>)object2);
        if (jsonSerializer == null) {
            if (((ResolvedType)this._valueType).hasGenericTypes()) {
                object2 = ((DatabindContext)object).constructSpecializedType(this._valueType, (Class<?>)object2);
                jsonSerializer = ((SerializerProvider)object).findPrimaryPropertySerializer((JavaType)object2, this._property);
                object = this._dynamicSerializers.addSerializer((JavaType)object2, jsonSerializer);
                this._dynamicSerializers = ((PropertySerializerMap$SerializerAndMapResult)object).map;
            } else {
                jsonSerializer = ((SerializerProvider)object).findPrimaryPropertySerializer((Class<?>)object2, this._property);
                object2 = this._dynamicSerializers.addSerializer((Class<?>)object2, jsonSerializer);
                this._dynamicSerializers = ((PropertySerializerMap$SerializerAndMapResult)object2).map;
            }
        }
        return jsonSerializer;
    }

    public String toString() {
        return "(@JsonValue serializer for method " + this._accessor.getDeclaringClass() + "#" + this._accessor.getName() + ")";
    }
}

