/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializerBase;
import java.math.BigDecimal;

final class NumberSerializer$BigDecimalAsStringSerializer
extends ToStringSerializerBase {
    static final NumberSerializer$BigDecimalAsStringSerializer BD_INSTANCE = new NumberSerializer$BigDecimalAsStringSerializer();

    public NumberSerializer$BigDecimalAsStringSerializer() {
        super(BigDecimal.class);
    }

    @Override
    public final boolean isEmpty(SerializerProvider serializerProvider, Object object) {
        return false;
    }

    @Override
    public final void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (jsonGenerator.isEnabled(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN)) {
            if (!this._verifyBigDecimalRange(jsonGenerator, (BigDecimal)(object = (BigDecimal)object))) {
                String string = String.format("Attempt to write plain `java.math.BigDecimal` (see JsonGenerator.Feature.WRITE_BIGDECIMAL_AS_PLAIN) with illegal scale (%d): needs to be between [-%d, %d]", ((BigDecimal)object).scale(), 9999, 9999);
                serializerProvider.reportMappingProblem(string, new Object[0]);
            }
            object = ((BigDecimal)object).toPlainString();
        } else {
            object = object.toString();
        }
        jsonGenerator.writeString((String)object);
    }

    @Override
    public final String valueToString(Object object) {
        throw new IllegalStateException();
    }

    protected final boolean _verifyBigDecimalRange(JsonGenerator jsonGenerator, BigDecimal bigDecimal) {
        int n2 = bigDecimal.scale();
        return n2 >= -9999 && n2 <= 9999;
    }
}

