/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.annotation.JsonFormat$Value;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser$NumberType;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.NumberSerializer$BigDecimalAsStringSerializer;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;

@JacksonStdImpl
public class NumberSerializer
extends StdScalarSerializer<Number>
implements ContextualSerializer {
    public static final NumberSerializer instance = new NumberSerializer((Class<? extends Number>)Number.class);
    protected static final int MAX_BIG_DECIMAL_SCALE = 9999;
    protected final boolean _isInt;

    public NumberSerializer(Class<? extends Number> clazz) {
        super(clazz, false);
        this._isInt = clazz == BigInteger.class;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider object, BeanProperty beanProperty) {
        if ((object = this.findFormatOverrides((SerializerProvider)object, beanProperty, ((JsonSerializer)this).handledType())) != null) {
            switch (((JsonFormat$Value)object).getShape()) {
                case STRING: {
                    if (((JsonSerializer)this).handledType() == BigDecimal.class) {
                        return NumberSerializer.bigDecimalAsStringSerializer();
                    }
                    return ToStringSerializer.instance;
                }
            }
        }
        return this;
    }

    @Override
    public void serialize(Number number, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (number instanceof BigDecimal) {
            jsonGenerator.writeNumber((BigDecimal)number);
            return;
        }
        if (number instanceof BigInteger) {
            jsonGenerator.writeNumber((BigInteger)number);
            return;
        }
        if (number instanceof Long) {
            jsonGenerator.writeNumber(number.longValue());
            return;
        }
        if (number instanceof Double) {
            jsonGenerator.writeNumber(number.doubleValue());
            return;
        }
        if (number instanceof Float) {
            jsonGenerator.writeNumber(number.floatValue());
            return;
        }
        if (number instanceof Integer || number instanceof Byte || number instanceof Short) {
            jsonGenerator.writeNumber(number.intValue());
            return;
        }
        jsonGenerator.writeNumber(number.toString());
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        NumberSerializer numberSerializer = this;
        return numberSerializer.createSchemaNode(numberSerializer._isInt ? "integer" : "number", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        if (this._isInt) {
            this.visitIntFormat(jsonFormatVisitorWrapper, javaType, JsonParser$NumberType.BIG_INTEGER);
            return;
        }
        if (((JsonSerializer)this).handledType() == BigDecimal.class) {
            this.visitFloatFormat(jsonFormatVisitorWrapper, javaType, JsonParser$NumberType.BIG_DECIMAL);
            return;
        }
        jsonFormatVisitorWrapper.expectNumberFormat(javaType);
    }

    public static JsonSerializer<?> bigDecimalAsStringSerializer() {
        return NumberSerializer$BigDecimalAsStringSerializer.BD_INSTANCE;
    }
}

