/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StdArraySerializers$BooleanArraySerializer
extends ArraySerializerBase<boolean[]> {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Boolean.class);

    public StdArraySerializers$BooleanArraySerializer() {
        super(boolean[].class);
    }

    protected StdArraySerializers$BooleanArraySerializer(StdArraySerializers$BooleanArraySerializer stdArraySerializers$BooleanArraySerializer, BeanProperty beanProperty, Boolean bl) {
        super(stdArraySerializers$BooleanArraySerializer, beanProperty, bl);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
        return new StdArraySerializers$BooleanArraySerializer(this, beanProperty, bl);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return this;
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return null;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, boolean[] blArray) {
        return blArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(boolean[] blArray) {
        return blArray.length == 1;
    }

    @Override
    public final void serialize(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = blArray.length;
        if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
            this.serializeContents(blArray, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(blArray, n2);
        this.serializeContents(blArray, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(boolean[] blArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = blArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jsonGenerator.writeBoolean(blArray[i2]);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider object, Type type) {
        object = this.createSchemaNode("array", true);
        ((ObjectNode)object).set("items", this.createSchemaNode("boolean"));
        return object;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.BOOLEAN);
    }
}

