/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StdArraySerializers$CharArraySerializer
extends StdSerializer<char[]> {
    public StdArraySerializers$CharArraySerializer() {
        super(char[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, char[] cArray) {
        return cArray.length == 0;
    }

    @Override
    public void serialize(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        if (serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS)) {
            jsonGenerator.writeStartArray(cArray, cArray.length);
            this._writeArrayContents(jsonGenerator, cArray);
            jsonGenerator.writeEndArray();
            return;
        }
        jsonGenerator.writeString(cArray, 0, cArray.length);
    }

    @Override
    public void serializeWithType(char[] cArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) {
        WritableTypeId writableTypeId;
        boolean bl = serializerProvider.isEnabled(SerializationFeature.WRITE_CHAR_ARRAYS_AS_JSON_ARRAYS);
        if (bl) {
            writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(cArray, JsonToken.START_ARRAY));
            this._writeArrayContents(jsonGenerator, cArray);
        } else {
            writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(cArray, JsonToken.VALUE_STRING));
            jsonGenerator.writeString(cArray, 0, cArray.length);
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    private final void _writeArrayContents(JsonGenerator jsonGenerator, char[] cArray) {
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jsonGenerator.writeString(cArray, i2, 1);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider object, Type object2) {
        object = this.createSchemaNode("array", true);
        object2 = this.createSchemaNode("string");
        ((ObjectNode)object2).put("type", "string");
        return ((ObjectNode)object).set("items", (JsonNode)object2);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.STRING);
    }
}

