/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StdArraySerializers$IntArraySerializer
extends ArraySerializerBase<int[]> {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Integer.TYPE);

    public StdArraySerializers$IntArraySerializer() {
        super(int[].class);
    }

    protected StdArraySerializers$IntArraySerializer(StdArraySerializers$IntArraySerializer stdArraySerializers$IntArraySerializer, BeanProperty beanProperty, Boolean bl) {
        super(stdArraySerializers$IntArraySerializer, beanProperty, bl);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
        return new StdArraySerializers$IntArraySerializer(this, beanProperty, bl);
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer typeSerializer) {
        return this;
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return null;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, int[] nArray) {
        return nArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(int[] nArray) {
        return nArray.length == 1;
    }

    @Override
    public final void serialize(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = nArray.length;
        if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
            this.serializeContents(nArray, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeArray(nArray, 0, nArray.length);
    }

    @Override
    public void serializeContents(int[] nArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jsonGenerator.writeNumber(nArray[i2]);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider serializerProvider, Type type) {
        return this.createSchemaNode("array", true).set("items", this.createSchemaNode("integer"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.INTEGER);
    }
}

