/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.std.StdArraySerializers$TypedPrimitiveArraySerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;

@JacksonStdImpl
public class StdArraySerializers$ShortArraySerializer
extends StdArraySerializers$TypedPrimitiveArraySerializer<short[]> {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(Short.TYPE);

    public StdArraySerializers$ShortArraySerializer() {
        super(short[].class);
    }

    public StdArraySerializers$ShortArraySerializer(StdArraySerializers$ShortArraySerializer stdArraySerializers$ShortArraySerializer, BeanProperty beanProperty, Boolean bl) {
        super(stdArraySerializers$ShortArraySerializer, beanProperty, bl);
    }

    @Override
    public JsonSerializer<?> _withResolved(BeanProperty beanProperty, Boolean bl) {
        return new StdArraySerializers$ShortArraySerializer(this, beanProperty, bl);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return null;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializerProvider, short[] sArray) {
        return sArray.length == 0;
    }

    @Override
    public boolean hasSingleElement(short[] sArray) {
        return sArray.length == 1;
    }

    @Override
    public final void serialize(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = sArray.length;
        if (n2 == 1 && this._shouldUnwrapSingle(serializerProvider)) {
            this.serializeContents(sArray, jsonGenerator, serializerProvider);
            return;
        }
        jsonGenerator.writeStartArray(sArray, n2);
        this.serializeContents(sArray, jsonGenerator, serializerProvider);
        jsonGenerator.writeEndArray();
    }

    @Override
    public void serializeContents(short[] sArray, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        int n2 = sArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            jsonGenerator.writeNumber((int)sArray[i2]);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider object, Type type) {
        object = this.createSchemaNode("array", true);
        return ((ObjectNode)object).set("items", this.createSchemaNode("integer"));
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) {
        this.visitArrayFormat(jsonFormatVisitorWrapper, javaType, JsonFormatTypes.INTEGER);
    }
}

