/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.util.Calendar;
import java.util.Date;

public class StdKeySerializers$Default
extends StdSerializer<Object> {
    static final int TYPE_DATE = 1;
    static final int TYPE_CALENDAR = 2;
    static final int TYPE_CLASS = 3;
    static final int TYPE_ENUM = 4;
    static final int TYPE_INTEGER = 5;
    static final int TYPE_LONG = 6;
    static final int TYPE_BYTE_ARRAY = 7;
    static final int TYPE_TO_STRING = 8;
    protected final int _typeId;

    public StdKeySerializers$Default(int n2, Class<?> clazz) {
        super(clazz, false);
        this._typeId = n2;
    }

    @Override
    public void serialize(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) {
        switch (this._typeId) {
            case 1: {
                serializerProvider.defaultSerializeDateKey((Date)object, jsonGenerator);
                return;
            }
            case 2: {
                serializerProvider.defaultSerializeDateKey(((Calendar)object).getTimeInMillis(), jsonGenerator);
                return;
            }
            case 3: {
                jsonGenerator.writeFieldName(((Class)object).getName());
                return;
            }
            case 4: {
                if (serializerProvider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING)) {
                    object = object.toString();
                } else {
                    object = (Enum)object;
                    object = serializerProvider.isEnabled(SerializationFeature.WRITE_ENUM_KEYS_USING_INDEX) ? String.valueOf(((Enum)object).ordinal()) : ((Enum)object).name();
                }
                jsonGenerator.writeFieldName((String)object);
                return;
            }
            case 5: 
            case 6: {
                jsonGenerator.writeFieldId(((Number)object).longValue());
                return;
            }
            case 7: {
                object = serializerProvider.getConfig().getBase64Variant().encode((byte[])object);
                jsonGenerator.writeFieldName((String)object);
                return;
            }
        }
        jsonGenerator.writeFieldName(object.toString());
    }
}

