/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBase;
import com.fasterxml.jackson.databind.type.TypeBindings;
import java.lang.reflect.TypeVariable;
import java.util.Collection;

public class CollectionLikeType
extends TypeBase {
    private static final long serialVersionUID = 1L;
    protected final JavaType _elementType;

    protected CollectionLikeType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray, JavaType javaType2, Object object, Object object2, boolean bl) {
        super(clazz, typeBindings, javaType, javaTypeArray, javaType2.hashCode(), object, object2, bl);
        this._elementType = javaType2;
    }

    protected CollectionLikeType(TypeBase typeBase, JavaType javaType) {
        super(typeBase);
        this._elementType = javaType;
    }

    public static CollectionLikeType construct(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray, JavaType javaType2) {
        return new CollectionLikeType(clazz, typeBindings, javaType, javaTypeArray, javaType2, null, null, false);
    }

    @Deprecated
    public static CollectionLikeType construct(Class<?> clazz, JavaType javaType) {
        Object object = clazz.getTypeParameters();
        object = object == null || ((TypeVariable<Class<?>>[])object).length != 1 ? TypeBindings.emptyBindings() : TypeBindings.create(clazz, javaType);
        return new CollectionLikeType(clazz, (TypeBindings)object, CollectionLikeType._bogusSuperClass(clazz), null, javaType, (Object)null, (Object)null, false);
    }

    public static CollectionLikeType upgradeFrom(JavaType javaType, JavaType javaType2) {
        if (javaType instanceof TypeBase) {
            return new CollectionLikeType((TypeBase)javaType, javaType2);
        }
        throw new IllegalArgumentException("Cannot upgrade from an instance of " + javaType.getClass());
    }

    @Override
    @Deprecated
    public JavaType _narrow(Class<?> clazz) {
        return new CollectionLikeType(clazz, this._bindings, this._superClass, this._superInterfaces, this._elementType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType withContentType(JavaType javaType) {
        if (this._elementType == javaType) {
            return this;
        }
        return new CollectionLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, javaType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public CollectionLikeType withTypeHandler(Object object) {
        return new CollectionLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._elementType, this._valueHandler, object, this._asStatic);
    }

    @Override
    public CollectionLikeType withContentTypeHandler(Object object) {
        return new CollectionLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._elementType.withTypeHandler(object), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public CollectionLikeType withValueHandler(Object object) {
        return new CollectionLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._elementType, object, this._typeHandler, this._asStatic);
    }

    @Override
    public CollectionLikeType withContentValueHandler(Object object) {
        return new CollectionLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._elementType.withValueHandler(object), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType withHandlersFrom(JavaType javaType) {
        JavaType javaType2 = super.withHandlersFrom(javaType);
        if ((javaType = javaType.getContentType()) != null && (javaType = this._elementType.withHandlersFrom(javaType)) != this._elementType) {
            javaType2 = javaType2.withContentType(javaType);
        }
        return javaType2;
    }

    @Override
    public CollectionLikeType withStaticTyping() {
        if (this._asStatic) {
            return this;
        }
        return new CollectionLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._elementType.withStaticTyping(), this._valueHandler, this._typeHandler, true);
    }

    @Override
    public JavaType refine(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return new CollectionLikeType(clazz, typeBindings, javaType, javaTypeArray, this._elementType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public boolean isCollectionLikeType() {
        return true;
    }

    @Override
    public JavaType getContentType() {
        return this._elementType;
    }

    @Override
    public Object getContentValueHandler() {
        return this._elementType.getValueHandler();
    }

    @Override
    public Object getContentTypeHandler() {
        return this._elementType.getTypeHandler();
    }

    @Override
    public boolean hasHandlers() {
        return super.hasHandlers() || this._elementType.hasHandlers();
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return CollectionLikeType._classSignature(this._class, stringBuilder, true);
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        CollectionLikeType._classSignature(this._class, stringBuilder, false);
        stringBuilder.append('<');
        this._elementType.getGenericSignature(stringBuilder);
        stringBuilder.append(">;");
        return stringBuilder;
    }

    @Override
    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._elementType != null && this._hasNTypeParameters(1)) {
            stringBuilder.append('<');
            stringBuilder.append(this._elementType.toCanonical());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Deprecated
    public boolean isTrueCollectionType() {
        return Collection.class.isAssignableFrom(this._class);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        object = (CollectionLikeType)object;
        return this._class == ((JavaType)object)._class && this._elementType.equals(((CollectionLikeType)object)._elementType);
    }

    @Override
    public String toString() {
        return "[collection-like type; class " + this._class.getName() + ", contains " + this._elementType + "]";
    }
}

