/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBase;
import com.fasterxml.jackson.databind.type.TypeBindings;
import java.lang.reflect.TypeVariable;
import java.util.Map;

public class MapLikeType
extends TypeBase {
    private static final long serialVersionUID = 1L;
    protected final JavaType _keyType;
    protected final JavaType _valueType;

    protected MapLikeType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray, JavaType javaType2, JavaType javaType3, Object object, Object object2, boolean bl) {
        super(clazz, typeBindings, javaType, javaTypeArray, javaType2.hashCode() ^ javaType3.hashCode(), object, object2, bl);
        this._keyType = javaType2;
        this._valueType = javaType3;
    }

    protected MapLikeType(TypeBase typeBase, JavaType javaType, JavaType javaType2) {
        super(typeBase);
        this._keyType = javaType;
        this._valueType = javaType2;
    }

    public static MapLikeType upgradeFrom(JavaType javaType, JavaType javaType2, JavaType javaType3) {
        if (javaType instanceof TypeBase) {
            return new MapLikeType((TypeBase)javaType, javaType2, javaType3);
        }
        throw new IllegalArgumentException("Cannot upgrade from an instance of " + javaType.getClass());
    }

    @Deprecated
    public static MapLikeType construct(Class<?> clazz, JavaType javaType, JavaType javaType2) {
        Object object = clazz.getTypeParameters();
        object = object == null || ((TypeVariable<Class<?>>[])object).length != 2 ? TypeBindings.emptyBindings() : TypeBindings.create(clazz, javaType, javaType2);
        return new MapLikeType(clazz, (TypeBindings)object, MapLikeType._bogusSuperClass(clazz), null, javaType, javaType2, null, null, false);
    }

    @Override
    @Deprecated
    public JavaType _narrow(Class<?> clazz) {
        return new MapLikeType(clazz, this._bindings, this._superClass, this._superInterfaces, this._keyType, this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    public MapLikeType withKeyType(JavaType javaType) {
        if (javaType == this._keyType) {
            return this;
        }
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, javaType, this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType withContentType(JavaType javaType) {
        if (this._valueType == javaType) {
            return this;
        }
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._keyType, javaType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public MapLikeType withTypeHandler(Object object) {
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._keyType, this._valueType, this._valueHandler, object, this._asStatic);
    }

    @Override
    public MapLikeType withContentTypeHandler(Object object) {
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._keyType, this._valueType.withTypeHandler(object), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public MapLikeType withValueHandler(Object object) {
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._keyType, this._valueType, object, this._typeHandler, this._asStatic);
    }

    @Override
    public MapLikeType withContentValueHandler(Object object) {
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._keyType, this._valueType.withValueHandler(object), this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType withHandlersFrom(JavaType javaType) {
        JavaType javaType2 = super.withHandlersFrom(javaType);
        JavaType javaType3 = javaType.getKeyType();
        if (javaType2 instanceof MapLikeType && javaType3 != null && (javaType3 = this._keyType.withHandlersFrom(javaType3)) != this._keyType) {
            javaType2 = ((MapLikeType)javaType2).withKeyType(javaType3);
        }
        if ((javaType3 = javaType.getContentType()) != null && (javaType = this._valueType.withHandlersFrom(javaType3)) != this._valueType) {
            javaType2 = javaType2.withContentType(javaType);
        }
        return javaType2;
    }

    @Override
    public MapLikeType withStaticTyping() {
        if (this._asStatic) {
            return this;
        }
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._keyType, this._valueType.withStaticTyping(), this._valueHandler, this._typeHandler, true);
    }

    @Override
    public JavaType refine(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return new MapLikeType(clazz, typeBindings, javaType, javaTypeArray, this._keyType, this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._keyType != null && this._hasNTypeParameters(2)) {
            stringBuilder.append('<');
            stringBuilder.append(this._keyType.toCanonical());
            stringBuilder.append(',');
            stringBuilder.append(this._valueType.toCanonical());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isContainerType() {
        return true;
    }

    @Override
    public boolean isMapLikeType() {
        return true;
    }

    @Override
    public JavaType getKeyType() {
        return this._keyType;
    }

    @Override
    public JavaType getContentType() {
        return this._valueType;
    }

    @Override
    public Object getContentValueHandler() {
        return this._valueType.getValueHandler();
    }

    @Override
    public Object getContentTypeHandler() {
        return this._valueType.getTypeHandler();
    }

    @Override
    public boolean hasHandlers() {
        return super.hasHandlers() || this._valueType.hasHandlers() || this._keyType.hasHandlers();
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return MapLikeType._classSignature(this._class, stringBuilder, true);
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        MapLikeType._classSignature(this._class, stringBuilder, false);
        stringBuilder.append('<');
        this._keyType.getGenericSignature(stringBuilder);
        this._valueType.getGenericSignature(stringBuilder);
        stringBuilder.append(">;");
        return stringBuilder;
    }

    public MapLikeType withKeyTypeHandler(Object object) {
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._keyType.withTypeHandler(object), this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    public MapLikeType withKeyValueHandler(Object object) {
        return new MapLikeType(this._class, this._bindings, this._superClass, this._superInterfaces, this._keyType.withValueHandler(object), this._valueType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Deprecated
    public boolean isTrueMapType() {
        return Map.class.isAssignableFrom(this._class);
    }

    @Override
    public String toString() {
        return String.format("[map-like type; class %s, %s -> %s]", this._class.getName(), this._keyType, this._valueType);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        object = (MapLikeType)object;
        return this._class == ((JavaType)object)._class && this._keyType.equals(((MapLikeType)object)._keyType) && this._valueType.equals(((MapLikeType)object)._valueType);
    }
}

