/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.SimpleType;
import com.fasterxml.jackson.databind.type.TypeBase;
import com.fasterxml.jackson.databind.type.TypeBindings;
import java.util.Objects;

public class ReferenceType
extends SimpleType {
    private static final long serialVersionUID = 1L;
    protected final JavaType _referencedType;
    protected final JavaType _anchorType;

    protected ReferenceType(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray, JavaType javaType2, JavaType javaType3, Object object, Object object2, boolean bl) {
        super(clazz, typeBindings, javaType, javaTypeArray, Objects.hashCode(javaType2), object, object2, bl);
        this._referencedType = javaType2;
        this._anchorType = javaType3 == null ? this : javaType3;
    }

    protected ReferenceType(TypeBase typeBase, JavaType javaType) {
        super(typeBase);
        this._referencedType = javaType;
        this._anchorType = this;
    }

    public static ReferenceType upgradeFrom(JavaType javaType, JavaType javaType2) {
        if (javaType2 == null) {
            throw new IllegalArgumentException("Missing referencedType");
        }
        if (javaType instanceof TypeBase) {
            return new ReferenceType((TypeBase)javaType, javaType2);
        }
        throw new IllegalArgumentException("Cannot upgrade from an instance of " + javaType.getClass());
    }

    public static ReferenceType construct(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray, JavaType javaType2) {
        return new ReferenceType(clazz, typeBindings, javaType, javaTypeArray, javaType2, null, null, null, false);
    }

    @Deprecated
    public static ReferenceType construct(Class<?> clazz, JavaType javaType) {
        return new ReferenceType(clazz, TypeBindings.emptyBindings(), null, null, null, javaType, null, null, false);
    }

    @Override
    public JavaType withContentType(JavaType javaType) {
        if (this._referencedType == javaType) {
            return this;
        }
        return new ReferenceType(this._class, this._bindings, this._superClass, this._superInterfaces, javaType, this._anchorType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public ReferenceType withTypeHandler(Object object) {
        if (object == this._typeHandler) {
            return this;
        }
        return new ReferenceType(this._class, this._bindings, this._superClass, this._superInterfaces, this._referencedType, this._anchorType, this._valueHandler, object, this._asStatic);
    }

    @Override
    public ReferenceType withContentTypeHandler(Object object) {
        if (object == this._referencedType.getTypeHandler()) {
            return this;
        }
        return new ReferenceType(this._class, this._bindings, this._superClass, this._superInterfaces, this._referencedType.withTypeHandler(object), this._anchorType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public ReferenceType withValueHandler(Object object) {
        if (object == this._valueHandler) {
            return this;
        }
        return new ReferenceType(this._class, this._bindings, this._superClass, this._superInterfaces, this._referencedType, this._anchorType, object, this._typeHandler, this._asStatic);
    }

    @Override
    public ReferenceType withContentValueHandler(Object object) {
        if (object == this._referencedType.getValueHandler()) {
            return this;
        }
        object = this._referencedType.withValueHandler(object);
        return new ReferenceType(this._class, this._bindings, this._superClass, this._superInterfaces, (JavaType)object, this._anchorType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public ReferenceType withStaticTyping() {
        if (this._asStatic) {
            return this;
        }
        return new ReferenceType(this._class, this._bindings, this._superClass, this._superInterfaces, this._referencedType.withStaticTyping(), this._anchorType, this._valueHandler, this._typeHandler, true);
    }

    @Override
    public JavaType refine(Class<?> clazz, TypeBindings typeBindings, JavaType javaType, JavaType[] javaTypeArray) {
        return new ReferenceType(clazz, this._bindings, javaType, javaTypeArray, this._referencedType, this._anchorType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    protected String buildCanonicalName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this._class.getName());
        if (this._referencedType != null && this._hasNTypeParameters(1)) {
            stringBuilder.append('<');
            stringBuilder.append(this._referencedType.toCanonical());
            stringBuilder.append('>');
        }
        return stringBuilder.toString();
    }

    @Override
    @Deprecated
    public JavaType _narrow(Class<?> clazz) {
        return new ReferenceType(clazz, this._bindings, this._superClass, this._superInterfaces, this._referencedType, this._anchorType, this._valueHandler, this._typeHandler, this._asStatic);
    }

    @Override
    public JavaType getContentType() {
        return this._referencedType;
    }

    @Override
    public JavaType getReferencedType() {
        return this._referencedType;
    }

    @Override
    public boolean hasContentType() {
        return true;
    }

    @Override
    public boolean isReferenceType() {
        return true;
    }

    @Override
    public StringBuilder getErasedSignature(StringBuilder stringBuilder) {
        return ReferenceType._classSignature(this._class, stringBuilder, true);
    }

    @Override
    public StringBuilder getGenericSignature(StringBuilder stringBuilder) {
        ReferenceType._classSignature(this._class, stringBuilder, false);
        stringBuilder.append('<');
        stringBuilder = this._referencedType.getGenericSignature(stringBuilder);
        stringBuilder.append(">;");
        return stringBuilder;
    }

    public JavaType getAnchorType() {
        return this._anchorType;
    }

    public boolean isAnchorType() {
        return this._anchorType == this;
    }

    @Override
    public String toString() {
        return new StringBuilder(40).append("[reference type, class ").append(this.buildCanonicalName()).append('<').append(this._referencedType).append('>').append(']').toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        object = (ReferenceType)object;
        if (((JavaType)object)._class != this._class) {
            return false;
        }
        return this._referencedType.equals(((ReferenceType)object)._referencedType);
    }
}

