/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.type;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeBindings;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.type.TypeParser$MyTokenizer;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class TypeParser
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final TypeFactory _factory;

    public TypeParser(TypeFactory typeFactory) {
        this._factory = typeFactory;
    }

    public TypeParser withFactory(TypeFactory typeFactory) {
        if (typeFactory == this._factory) {
            return this;
        }
        return new TypeParser(typeFactory);
    }

    public JavaType parse(String object) {
        object = new TypeParser$MyTokenizer(((String)object).trim());
        JavaType javaType = this.parseType((TypeParser$MyTokenizer)object);
        if (((TypeParser$MyTokenizer)object).hasMoreTokens()) {
            throw this._problem((TypeParser$MyTokenizer)object, "Unexpected tokens after complete type");
        }
        return javaType;
    }

    protected JavaType parseType(TypeParser$MyTokenizer object) {
        if (!((TypeParser$MyTokenizer)object).hasMoreTokens()) {
            throw this._problem((TypeParser$MyTokenizer)object, "Unexpected end-of-string");
        }
        Class<?> clazz = this.findClass(((TypeParser$MyTokenizer)object).nextToken(), (TypeParser$MyTokenizer)object);
        if (((TypeParser$MyTokenizer)object).hasMoreTokens()) {
            String string = ((TypeParser$MyTokenizer)object).nextToken();
            if ("<".equals(string)) {
                object = this.parseTypes((TypeParser$MyTokenizer)object);
                object = TypeBindings.create(clazz, (List<JavaType>)object);
                return this._factory._fromClass(null, clazz, (TypeBindings)object);
            }
            ((TypeParser$MyTokenizer)object).pushBack(string);
        }
        return this._factory._fromClass(null, clazz, TypeBindings.emptyBindings());
    }

    protected List<JavaType> parseTypes(TypeParser$MyTokenizer typeParser$MyTokenizer) {
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>();
        while (typeParser$MyTokenizer.hasMoreTokens()) {
            arrayList.add(this.parseType(typeParser$MyTokenizer));
            if (!typeParser$MyTokenizer.hasMoreTokens()) break;
            String string = typeParser$MyTokenizer.nextToken();
            if (">".equals(string)) {
                return arrayList;
            }
            if (",".equals(string)) continue;
            throw this._problem(typeParser$MyTokenizer, "Unexpected token '" + string + "', expected ',' or '>')");
        }
        throw this._problem(typeParser$MyTokenizer, "Unexpected end-of-string");
    }

    protected Class<?> findClass(String string, TypeParser$MyTokenizer typeParser$MyTokenizer) {
        try {
            return this._factory.findClass(string);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ClassUtil.throwIfRTE(exception);
            throw this._problem(typeParser$MyTokenizer, "Cannot locate class '" + string + "', problem: " + exception2.getMessage());
        }
    }

    protected IllegalArgumentException _problem(TypeParser$MyTokenizer typeParser$MyTokenizer, String string) {
        return new IllegalArgumentException(String.format("Failed to parse type '%s' (remaining: '%s'): %s", typeParser$MyTokenizer.getAllInput(), typeParser$MyTokenizer.getRemainingInput(), string));
    }
}

