/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.annotation.NoClass;
import com.fasterxml.jackson.databind.util.ClassUtil$Ctor;
import com.fasterxml.jackson.databind.util.ClassUtil$EnumTypeLocator;
import com.fasterxml.jackson.databind.util.Named;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ClassUtil {
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    private static final ClassUtil$Ctor[] NO_CTORS = new ClassUtil$Ctor[0];
    private static final Iterator<?> EMPTY_ITERATOR = Collections.emptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static List<JavaType> findSuperTypes(JavaType javaType, Class<?> clazz, boolean bl) {
        if (javaType == null || ((ResolvedType)javaType).hasRawClass(clazz) || ((ResolvedType)javaType).hasRawClass(Object.class)) {
            return Collections.emptyList();
        }
        ArrayList<JavaType> arrayList = new ArrayList<JavaType>(8);
        ClassUtil._addSuperTypes(javaType, clazz, arrayList, bl);
        return arrayList;
    }

    public static List<Class<?>> findRawSuperTypes(Class<?> clazz, Class<?> clazz2, boolean bl) {
        if (clazz == null || clazz == clazz2 || clazz == Object.class) {
            return Collections.emptyList();
        }
        ArrayList arrayList = new ArrayList(8);
        ClassUtil._addRawSuperTypes(clazz, clazz2, arrayList, bl);
        return arrayList;
    }

    public static List<Class<?>> findSuperClasses(Class<?> clazz, Class<?> clazz2, boolean bl) {
        ArrayList arrayList = new ArrayList(8);
        if (clazz != null && clazz != clazz2) {
            if (bl) {
                arrayList.add(clazz);
            }
            while ((clazz = clazz.getSuperclass()) != null && clazz != clazz2) {
                arrayList.add(clazz);
            }
        }
        return arrayList;
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2) {
        return ClassUtil.findSuperTypes(clazz, clazz2, new ArrayList(8));
    }

    @Deprecated
    public static List<Class<?>> findSuperTypes(Class<?> clazz, Class<?> clazz2, List<Class<?>> list) {
        ClassUtil._addRawSuperTypes(clazz, clazz2, list, false);
        return list;
    }

    private static void _addSuperTypes(JavaType javaType, Class<?> clazz, Collection<JavaType> collection, boolean bl) {
        while (javaType != null) {
            Class<?> clazz2 = ((ResolvedType)javaType).getRawClass();
            if (clazz2 == clazz || clazz2 == Object.class) {
                return;
            }
            if (bl) {
                if (collection.contains(javaType)) {
                    return;
                }
                collection.add(javaType);
            }
            for (JavaType javaType2 : javaType.getInterfaces()) {
                ClassUtil._addSuperTypes(javaType2, clazz, collection, true);
            }
            bl = true;
            javaType = javaType.getSuperClass();
        }
        return;
    }

    private static void _addRawSuperTypes(Class<?> clazz, Class<?> clazz2, Collection<Class<?>> collection, boolean bl) {
        while (clazz != clazz2 && clazz != null && clazz != Object.class) {
            if (bl) {
                if (collection.contains(clazz)) {
                    return;
                }
                collection.add(clazz);
            }
            for (Class<?> clazz3 : ClassUtil._interfaces(clazz)) {
                ClassUtil._addRawSuperTypes(clazz3, clazz2, collection, true);
            }
            bl = true;
            clazz = clazz.getSuperclass();
        }
        return;
    }

    public static String canBeABeanType(Class<?> clazz) {
        if (clazz.isAnnotation()) {
            return "annotation";
        }
        if (clazz.isArray()) {
            return "array";
        }
        if (Enum.class.isAssignableFrom(clazz)) {
            return "enum";
        }
        if (clazz.isPrimitive()) {
            return "primitive";
        }
        return null;
    }

    public static String isLocalType(Class<?> clazz, boolean bl) {
        try {
            boolean bl2 = Modifier.isStatic(clazz.getModifiers());
            if (!bl2 && ClassUtil.hasEnclosingMethod(clazz)) {
                return "local/anonymous";
            }
            if (!bl && !bl2 && ClassUtil.getEnclosingClass(clazz) != null) {
                return "non-static member class";
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    public static Class<?> getOuterClass(Class<?> clazz) {
        if (!Modifier.isStatic(clazz.getModifiers())) {
            try {
                if (ClassUtil.hasEnclosingMethod(clazz)) {
                    return null;
                }
                return ClassUtil.getEnclosingClass(clazz);
            }
            catch (SecurityException securityException) {}
        }
        return null;
    }

    public static boolean isProxyType(Class<?> object) {
        return ((String)(object = ((Class)object).getName())).startsWith("net.sf.cglib.proxy.") || ((String)object).startsWith("org.hibernate.proxy.");
    }

    public static boolean isConcrete(Class<?> clazz) {
        int n2 = clazz.getModifiers();
        return (n2 & 0x600) == 0;
    }

    public static boolean isConcrete(Member member) {
        int n2 = member.getModifiers();
        return (n2 & 0x600) == 0;
    }

    public static boolean isCollectionMapOrArray(Class<?> clazz) {
        if (clazz.isArray()) {
            return true;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return true;
        }
        return Map.class.isAssignableFrom(clazz);
    }

    public static boolean isBogusClass(Class<?> clazz) {
        return clazz == Void.class || clazz == Void.TYPE || clazz == NoClass.class;
    }

    public static boolean isRecordType(Class<?> clazz) {
        return (clazz = clazz.getSuperclass()) != null && "java.lang.Record".equals(clazz.getName());
    }

    public static boolean isObjectOrPrimitive(Class<?> clazz) {
        return clazz == CLS_OBJECT || clazz.isPrimitive();
    }

    public static boolean hasClass(Object object, Class<?> clazz) {
        return object != null && object.getClass() == clazz;
    }

    public static void verifyMustOverride(Class<?> clazz, Object object, String string) {
        if (object.getClass() != clazz) {
            throw new IllegalStateException(String.format("Sub-class %s (of class %s) must override method '%s'", object.getClass().getName(), clazz.getName(), string));
        }
    }

    @Deprecated
    public static boolean hasGetterSignature(Method method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        Class<?>[] classArray = method.getParameterTypes();
        if (classArray != null && classArray.length != 0) {
            return false;
        }
        return Void.TYPE != method.getReturnType();
    }

    public static Throwable throwIfError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return throwable;
    }

    public static Throwable throwIfRTE(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        return throwable;
    }

    public static Throwable throwIfIOE(Throwable throwable) {
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        return throwable;
    }

    public static Throwable getRootCause(Throwable throwable) {
        while (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    public static Throwable throwRootCauseIfIOE(Throwable throwable) {
        return ClassUtil.throwIfIOE(ClassUtil.getRootCause(throwable));
    }

    public static void throwAsIAE(Throwable throwable) {
        Throwable throwable2 = throwable;
        ClassUtil.throwAsIAE(throwable2, throwable2.getMessage());
    }

    public static void throwAsIAE(Throwable throwable, String string) {
        ClassUtil.throwIfRTE(throwable);
        ClassUtil.throwIfError(throwable);
        throw new IllegalArgumentException(string, throwable);
    }

    public static <T> T throwAsMappingException(DeserializationContext deserializationContext, IOException iOException) {
        if (iOException instanceof JsonMappingException) {
            throw (JsonMappingException)iOException;
        }
        throw JsonMappingException.from(deserializationContext, iOException.getMessage()).withCause(iOException);
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable));
    }

    public static void unwrapAndThrowAsIAE(Throwable throwable, String string) {
        ClassUtil.throwAsIAE(ClassUtil.getRootCause(throwable), string);
    }

    public static void closeOnFailAndThrowAsIOE(JsonGenerator jsonGenerator, Exception exception) {
        jsonGenerator.disable(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT);
        try {
            jsonGenerator.close();
        }
        catch (Exception exception2) {
            exception.addSuppressed(exception2);
        }
        ClassUtil.throwIfIOE(exception);
        ClassUtil.throwIfRTE(exception);
        throw new RuntimeException(exception);
    }

    public static void closeOnFailAndThrowAsIOE(JsonGenerator jsonGenerator, Closeable closeable, Exception exception) {
        if (jsonGenerator != null) {
            jsonGenerator.disable(JsonGenerator$Feature.AUTO_CLOSE_JSON_CONTENT);
            try {
                jsonGenerator.close();
            }
            catch (Exception exception2) {
                exception.addSuppressed(exception2);
            }
        }
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception3) {
                exception.addSuppressed(exception3);
            }
        }
        ClassUtil.throwIfIOE(exception);
        ClassUtil.throwIfRTE(exception);
        throw new RuntimeException(exception);
    }

    public static <T> T createInstance(Class<T> clazz, boolean bl) {
        Constructor<T> constructor = ClassUtil.findConstructor(clazz, bl);
        if (constructor == null) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no default (no arg) constructor");
        }
        try {
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            constructor = exception;
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to instantiate class " + clazz.getName() + ", problem: " + ((Throwable)((Object)constructor)).getMessage());
            return null;
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clazz, boolean bl) {
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (bl) {
                ClassUtil.checkAndFixAccess(constructor, bl);
            } else if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("Default constructor for " + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: cannot instantiate type");
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            ClassUtil.unwrapAndThrowAsIAE(exception, "Failed to find default constructor of class " + clazz.getName() + ", problem: " + exception2.getMessage());
        }
        return null;
    }

    public static Class<?> classOf(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass();
    }

    public static Class<?> rawClass(JavaType javaType) {
        if (javaType == null) {
            return null;
        }
        return ((ResolvedType)javaType).getRawClass();
    }

    public static <T> T nonNull(T t2, T t3) {
        if (t2 == null) {
            return t3;
        }
        return t2;
    }

    public static String nullOrToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String nonNullString(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public static String quotedOr(Object object, String string) {
        if (object == null) {
            return string;
        }
        return String.format("\"%s\"", object);
    }

    public static String getClassDescription(Object clazz) {
        if (clazz == null) {
            return "unknown";
        }
        clazz = clazz instanceof Class ? (Class<?>)clazz : clazz.getClass();
        return ClassUtil.nameOf(clazz);
    }

    public static String getTypeDescription(JavaType javaType) {
        if (javaType == null) {
            return "[null]";
        }
        StringBuilder stringBuilder = new StringBuilder(80).append('`');
        stringBuilder.append(javaType.toCanonical());
        return stringBuilder.append('`').toString();
    }

    public static String classNameOf(Object clazz) {
        if (clazz == null) {
            return "[null]";
        }
        clazz = clazz instanceof Class ? (Class<?>)clazz : clazz.getClass();
        return ClassUtil.nameOf(clazz);
    }

    public static String nameOf(Class<?> object) {
        if (object == null) {
            return "[null]";
        }
        int n2 = 0;
        while (((Class)object).isArray()) {
            ++n2;
            object = ((Class)object).getComponentType();
        }
        Object object2 = object = ((Class)object).isPrimitive() ? ((Class)object).getSimpleName() : ((Class)object).getName();
        if (n2 > 0) {
            object = new StringBuilder((String)object);
            do {
                ((StringBuilder)object).append("[]");
            } while (--n2 > 0);
            object = ((StringBuilder)object).toString();
        }
        return ClassUtil.backticked((String)object);
    }

    public static String nameOf(Named named) {
        if (named == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(named.getName());
    }

    public static String name(String string) {
        if (string == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(string);
    }

    public static String name(PropertyName propertyName) {
        if (propertyName == null) {
            return "[null]";
        }
        return ClassUtil.apostrophed(propertyName.getSimpleName());
    }

    public static String backticked(String string) {
        if (string == null) {
            return "[null]";
        }
        return new StringBuilder(string.length() + 2).append('`').append(string).append('`').toString();
    }

    public static String apostrophed(String string) {
        if (string == null) {
            return "[null]";
        }
        return new StringBuilder(string.length() + 2).append('\'').append(string).append('\'').toString();
    }

    public static String exceptionMessage(Throwable throwable) {
        if (throwable instanceof JacksonException) {
            return ((JacksonException)throwable).getOriginalMessage();
        }
        if (throwable instanceof InvocationTargetException && throwable.getCause() != null) {
            return throwable.getCause().getMessage();
        }
        return throwable.getMessage();
    }

    public static Object defaultValue(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return 0;
        }
        if (clazz == Long.TYPE) {
            return 0L;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.FALSE;
        }
        if (clazz == Double.TYPE) {
            return 0.0;
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(0.0f);
        }
        if (clazz == Byte.TYPE) {
            return (byte)0;
        }
        if (clazz == Short.TYPE) {
            return (short)0;
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf('\u0000');
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> wrapperType(Class<?> clazz) {
        if (clazz == Integer.TYPE) {
            return Integer.class;
        }
        if (clazz == Long.TYPE) {
            return Long.class;
        }
        if (clazz == Boolean.TYPE) {
            return Boolean.class;
        }
        if (clazz == Double.TYPE) {
            return Double.class;
        }
        if (clazz == Float.TYPE) {
            return Float.class;
        }
        if (clazz == Byte.TYPE) {
            return Byte.class;
        }
        if (clazz == Short.TYPE) {
            return Short.class;
        }
        if (clazz == Character.TYPE) {
            return Character.class;
        }
        throw new IllegalArgumentException("Class " + clazz.getName() + " is not a primitive type");
    }

    public static Class<?> primitiveType(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.class) {
            return Integer.TYPE;
        }
        if (clazz == Long.class) {
            return Long.TYPE;
        }
        if (clazz == Boolean.class) {
            return Boolean.TYPE;
        }
        if (clazz == Double.class) {
            return Double.TYPE;
        }
        if (clazz == Float.class) {
            return Float.TYPE;
        }
        if (clazz == Byte.class) {
            return Byte.TYPE;
        }
        if (clazz == Short.class) {
            return Short.TYPE;
        }
        if (clazz == Character.class) {
            return Character.TYPE;
        }
        return null;
    }

    @Deprecated
    public static void checkAndFixAccess(Member member) {
        ClassUtil.checkAndFixAccess(member, false);
    }

    public static void checkAndFixAccess(Member member, boolean bl) {
        AccessibleObject accessibleObject = (AccessibleObject)((Object)member);
        try {
            Class<?> clazz = member.getDeclaringClass();
            boolean bl2 = Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
            if (!bl2 || bl && !ClassUtil.isJDKClass(clazz)) {
                accessibleObject.setAccessible(true);
            }
            return;
        }
        catch (SecurityException securityException) {
            if (!accessibleObject.isAccessible()) {
                Class<?> clazz = member.getDeclaringClass();
                throw new IllegalArgumentException("Cannot access " + member + " (from class " + clazz.getName() + "; failed to set access: " + securityException.getMessage());
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            if ("InaccessibleObjectException".equals(runtimeException.getClass().getSimpleName())) {
                throw new IllegalArgumentException(String.format("Failed to call `setAccess()` on %s '%s' (of class %s) due to `%s`, problem: %s", member.getClass().getSimpleName(), member.getName(), ClassUtil.nameOf(member.getDeclaringClass()), runtimeException.getClass().getName(), runtimeException.getMessage()), runtimeException);
            }
            throw runtimeException;
        }
    }

    public static boolean isEnumType(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumSet<?> enumSet) {
        if (!enumSet.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumSet.iterator().next());
        }
        return ClassUtil$EnumTypeLocator.instance.enumTypeFor(enumSet);
    }

    public static Class<? extends Enum<?>> findEnumType(EnumMap<?, ?> enumMap) {
        if (!enumMap.isEmpty()) {
            return ClassUtil.findEnumType((Enum)enumMap.keySet().iterator().next());
        }
        return ClassUtil$EnumTypeLocator.instance.enumTypeFor(enumMap);
    }

    public static Class<? extends Enum<?>> findEnumType(Enum<?> enum_) {
        return enum_.getDeclaringClass();
    }

    public static Class<? extends Enum<?>> findEnumType(Class<?> clazz) {
        if (clazz.getSuperclass() != Enum.class) {
            clazz = clazz.getSuperclass();
        }
        return clazz;
    }

    public static <T extends Annotation> Enum<?> findFirstAnnotatedEnumValue(Class<Enum<?>> clazz, Class<T> clazz2) {
        Field[] fieldArray = clazz.getDeclaredFields();
        Field[] fieldArray2 = fieldArray;
        fieldArray2 = fieldArray;
        int n2 = fieldArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object;
            Object object2 = fieldArray2[i2];
            if (!((Field)object2).isEnumConstant() || (object = ((Field)object2).getAnnotation(clazz2)) == null) continue;
            object2 = ((Field)object2).getName();
            object = clazz.getEnumConstants();
            int n3 = ((Enum<?>[])object).length;
            for (int i3 = 0; i3 < n3; ++i3) {
                T t2 = object[i3];
                if (!((String)object2).equals(((Enum)t2).name())) continue;
                return t2;
            }
        }
        return null;
    }

    public static boolean isJacksonStdImpl(Object object) {
        return object == null || ClassUtil.isJacksonStdImpl(object.getClass());
    }

    public static boolean isJacksonStdImpl(Class<?> clazz) {
        return clazz.getAnnotation(JacksonStdImpl.class) != null;
    }

    public static boolean isJDKClass(Class<?> object) {
        return ((String)(object = ((Class)object).getName())).startsWith("java.") || ((String)object).startsWith("javax.");
    }

    public static boolean isNonStaticInnerClass(Class<?> clazz) {
        return !Modifier.isStatic(clazz.getModifiers()) && ClassUtil.getEnclosingClass(clazz) != null;
    }

    @Deprecated
    public static String getPackageName(Class<?> annotatedElement) {
        if ((annotatedElement = ((Class)annotatedElement).getPackage()) == null) {
            return null;
        }
        return ((Package)annotatedElement).getName();
    }

    public static boolean hasEnclosingMethod(Class<?> clazz) {
        return !ClassUtil.isObjectOrPrimitive(clazz) && clazz.getEnclosingMethod() != null;
    }

    @Deprecated
    public static Field[] getDeclaredFields(Class<?> clazz) {
        return clazz.getDeclaredFields();
    }

    @Deprecated
    public static Method[] getDeclaredMethods(Class<?> clazz) {
        return clazz.getDeclaredMethods();
    }

    public static Annotation[] findClassAnnotations(Class<?> clazz) {
        if (ClassUtil.isObjectOrPrimitive(clazz)) {
            return NO_ANNOTATIONS;
        }
        return clazz.getDeclaredAnnotations();
    }

    public static Method[] getClassMethods(Class<?> clazz) {
        try {
            return clazz.getDeclaredMethods();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            Object object = Thread.currentThread().getContextClassLoader();
            if (object == null) {
                return ClassUtil._failGetClassMethods(clazz, noClassDefFoundError);
            }
            try {
                object = ((ClassLoader)object).loadClass(clazz.getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
                noClassDefFoundError.addSuppressed(classNotFoundException);
                return ClassUtil._failGetClassMethods(clazz, noClassDefFoundError);
            }
            try {
                return ((Class)object).getDeclaredMethods();
            }
            catch (Throwable throwable) {
                return ClassUtil._failGetClassMethods(clazz, throwable);
            }
        }
        catch (Throwable throwable) {
            return ClassUtil._failGetClassMethods(clazz, throwable);
        }
    }

    private static Method[] _failGetClassMethods(Class<?> clazz, Throwable throwable) {
        throw new IllegalArgumentException(String.format("Failed on call to `getDeclaredMethods()` on class `%s`, problem: (%s) %s", clazz.getName(), throwable.getClass().getName(), throwable.getMessage()), throwable);
    }

    public static ClassUtil$Ctor[] getConstructors(Class<?> constructorArray) {
        if (constructorArray.isInterface() || ClassUtil.isObjectOrPrimitive(constructorArray)) {
            return NO_CTORS;
        }
        constructorArray = constructorArray.getDeclaredConstructors();
        int n2 = constructorArray.length;
        ClassUtil$Ctor[] classUtil$CtorArray = new ClassUtil$Ctor[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            classUtil$CtorArray[i2] = new ClassUtil$Ctor(constructorArray[i2]);
        }
        return classUtil$CtorArray;
    }

    public static Class<?> getDeclaringClass(Class<?> clazz) {
        if (ClassUtil.isObjectOrPrimitive(clazz)) {
            return null;
        }
        return clazz.getDeclaringClass();
    }

    public static Type getGenericSuperclass(Class<?> clazz) {
        return clazz.getGenericSuperclass();
    }

    public static Type[] getGenericInterfaces(Class<?> clazz) {
        return clazz.getGenericInterfaces();
    }

    public static Class<?> getEnclosingClass(Class<?> clazz) {
        if (ClassUtil.isObjectOrPrimitive(clazz)) {
            return null;
        }
        return clazz.getEnclosingClass();
    }

    private static Class<?>[] _interfaces(Class<?> clazz) {
        return clazz.getInterfaces();
    }
}

