/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.JsonToken;
import java.util.TreeMap;

public final class TokenBuffer$Segment {
    public static final int TOKENS_PER_SEGMENT = 16;
    private static final JsonToken[] TOKEN_TYPES_BY_INDEX = new JsonToken[16];
    protected TokenBuffer$Segment _next;
    protected long _tokenTypes;
    protected final Object[] _tokens = new Object[16];
    protected TreeMap<Integer, Object> _nativeIds;

    public final JsonToken type(int n2) {
        long l2 = this._tokenTypes;
        if (n2 > 0) {
            l2 >>= n2 << 2;
        }
        n2 = (int)l2 & 0xF;
        return TOKEN_TYPES_BY_INDEX[n2];
    }

    public final int rawType(int n2) {
        long l2 = this._tokenTypes;
        if (n2 > 0) {
            l2 >>= n2 << 2;
        }
        n2 = (int)l2 & 0xF;
        return n2;
    }

    public final Object get(int n2) {
        return this._tokens[n2];
    }

    public final TokenBuffer$Segment next() {
        return this._next;
    }

    public final boolean hasIds() {
        return this._nativeIds != null;
    }

    public final TokenBuffer$Segment append(int n2, JsonToken jsonToken) {
        if (n2 < 16) {
            this.set(n2, jsonToken);
            return null;
        }
        this._next = new TokenBuffer$Segment();
        this._next.set(0, jsonToken);
        return this._next;
    }

    public final TokenBuffer$Segment append(int n2, JsonToken jsonToken, Object object, Object object2) {
        if (n2 < 16) {
            this.set(n2, jsonToken, object, object2);
            return null;
        }
        this._next = new TokenBuffer$Segment();
        this._next.set(0, jsonToken, object, object2);
        return this._next;
    }

    public final TokenBuffer$Segment append(int n2, JsonToken jsonToken, Object object) {
        if (n2 < 16) {
            this.set(n2, jsonToken, object);
            return null;
        }
        this._next = new TokenBuffer$Segment();
        this._next.set(0, jsonToken, object);
        return this._next;
    }

    public final TokenBuffer$Segment append(int n2, JsonToken jsonToken, Object object, Object object2, Object object3) {
        if (n2 < 16) {
            this.set(n2, jsonToken, object, object2, object3);
            return null;
        }
        this._next = new TokenBuffer$Segment();
        this._next.set(0, jsonToken, object, object2, object3);
        return this._next;
    }

    private void set(int n2, JsonToken jsonToken) {
        long l2 = jsonToken.ordinal();
        if (n2 > 0) {
            l2 <<= n2 << 2;
        }
        this._tokenTypes |= l2;
    }

    private void set(int n2, JsonToken jsonToken, Object object, Object object2) {
        long l2 = jsonToken.ordinal();
        if (n2 > 0) {
            l2 <<= n2 << 2;
        }
        this._tokenTypes |= l2;
        this.assignNativeIds(n2, object, object2);
    }

    private void set(int n2, JsonToken jsonToken, Object object) {
        this._tokens[n2] = object;
        long l2 = jsonToken.ordinal();
        if (n2 > 0) {
            l2 <<= n2 << 2;
        }
        this._tokenTypes |= l2;
    }

    private void set(int n2, JsonToken jsonToken, Object object, Object object2, Object object3) {
        this._tokens[n2] = object;
        long l2 = jsonToken.ordinal();
        if (n2 > 0) {
            l2 <<= n2 << 2;
        }
        this._tokenTypes |= l2;
        this.assignNativeIds(n2, object2, object3);
    }

    private final void assignNativeIds(int n2, Object object, Object object2) {
        if (this._nativeIds == null) {
            this._nativeIds = new TreeMap();
        }
        if (object != null) {
            this._nativeIds.put(this._objectIdIndex(n2), object);
        }
        if (object2 != null) {
            this._nativeIds.put(this._typeIdIndex(n2), object2);
        }
    }

    final Object findObjectId(int n2) {
        if (this._nativeIds == null) {
            return null;
        }
        return this._nativeIds.get(this._objectIdIndex(n2));
    }

    final Object findTypeId(int n2) {
        if (this._nativeIds == null) {
            return null;
        }
        return this._nativeIds.get(this._typeIdIndex(n2));
    }

    private final int _typeIdIndex(int n2) {
        int n3 = n2;
        return n3 + n3;
    }

    private final int _objectIdIndex(int n2) {
        int n3 = n2;
        return n3 + n3 + 1;
    }

    static {
        JsonToken[] jsonTokenArray = JsonToken.values();
        System.arraycopy(jsonTokenArray, 1, TOKEN_TYPES_BY_INDEX, 1, Math.min(15, jsonTokenArray.length - 1));
    }
}

