/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializable;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.util.RawValue;
import com.fasterxml.jackson.databind.util.TokenBuffer$Parser;
import com.fasterxml.jackson.databind.util.TokenBuffer$Segment;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;

public class TokenBuffer
extends JsonGenerator {
    protected static final int DEFAULT_GENERATOR_FEATURES = JsonGenerator$Feature.collectDefaults();
    protected ObjectCodec _objectCodec;
    protected JsonStreamContext _parentContext;
    protected int _generatorFeatures;
    protected boolean _closed;
    protected boolean _hasNativeTypeIds;
    protected boolean _hasNativeObjectIds;
    protected boolean _mayHaveNativeIds;
    protected boolean _forceBigDecimal;
    protected TokenBuffer$Segment _first;
    protected TokenBuffer$Segment _last;
    protected int _appendAt;
    protected Object _typeId;
    protected Object _objectId;
    protected boolean _hasNativeId = false;
    protected JsonWriteContext _writeContext;

    public TokenBuffer(ObjectCodec objectCodec, boolean bl) {
        this._objectCodec = objectCodec;
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext(null);
        TokenBuffer tokenBuffer = this;
        tokenBuffer._first = tokenBuffer._last = new TokenBuffer$Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = bl;
        this._hasNativeObjectIds = bl;
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
    }

    public TokenBuffer(JsonParser jsonParser) {
        this(jsonParser, null);
    }

    public TokenBuffer(JsonParser jsonParser, DeserializationContext deserializationContext) {
        this._objectCodec = jsonParser.getCodec();
        this._parentContext = jsonParser.getParsingContext();
        this._generatorFeatures = DEFAULT_GENERATOR_FEATURES;
        this._writeContext = JsonWriteContext.createRootContext(null);
        TokenBuffer tokenBuffer = this;
        tokenBuffer._first = tokenBuffer._last = new TokenBuffer$Segment();
        this._appendAt = 0;
        this._hasNativeTypeIds = jsonParser.canReadTypeId();
        this._hasNativeObjectIds = jsonParser.canReadObjectId();
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
        this._forceBigDecimal = deserializationContext == null ? false : deserializationContext.isEnabled(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    }

    @Deprecated
    public static TokenBuffer asCopyOfValue(JsonParser jsonParser) {
        TokenBuffer tokenBuffer = new TokenBuffer(jsonParser);
        ((JsonGenerator)tokenBuffer).copyCurrentStructure(jsonParser);
        return tokenBuffer;
    }

    public TokenBuffer overrideParentContext(JsonStreamContext jsonStreamContext) {
        this._parentContext = jsonStreamContext;
        return this;
    }

    public TokenBuffer forceUseOfBigDecimal(boolean bl) {
        this._forceBigDecimal = bl;
        return this;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    public JsonParser asParser() {
        TokenBuffer tokenBuffer = this;
        return tokenBuffer.asParser(tokenBuffer._objectCodec);
    }

    public JsonParser asParserOnFirstToken() {
        TokenBuffer tokenBuffer = this;
        JsonParser jsonParser = tokenBuffer.asParser(tokenBuffer._objectCodec);
        jsonParser.nextToken();
        return jsonParser;
    }

    public JsonParser asParser(ObjectCodec objectCodec) {
        return new TokenBuffer$Parser(this._first, objectCodec, this._hasNativeTypeIds, this._hasNativeObjectIds, this._parentContext);
    }

    public JsonParser asParser(JsonParser jsonParser) {
        TokenBuffer$Parser tokenBuffer$Parser = new TokenBuffer$Parser(this._first, jsonParser.getCodec(), this._hasNativeTypeIds, this._hasNativeObjectIds, this._parentContext);
        tokenBuffer$Parser.setLocation(jsonParser.getTokenLocation());
        return tokenBuffer$Parser;
    }

    public JsonToken firstToken() {
        return this._first.type(0);
    }

    public boolean isEmpty() {
        return this._appendAt == 0 && this._first == this._last;
    }

    public TokenBuffer append(TokenBuffer closeable) {
        if (!this._hasNativeTypeIds) {
            this._hasNativeTypeIds = ((JsonGenerator)closeable).canWriteTypeId();
        }
        if (!this._hasNativeObjectIds) {
            this._hasNativeObjectIds = ((JsonGenerator)closeable).canWriteObjectId();
        }
        this._mayHaveNativeIds = this._hasNativeTypeIds || this._hasNativeObjectIds;
        closeable = ((TokenBuffer)closeable).asParser();
        while (((JsonParser)closeable).nextToken() != null) {
            ((JsonGenerator)this).copyCurrentStructure((JsonParser)closeable);
        }
        return this;
    }

    public void serialize(JsonGenerator jsonGenerator) {
        block32: {
            boolean bl;
            TokenBuffer$Segment tokenBuffer$Segment = this._first;
            int n2 = -1;
            boolean bl2 = this._mayHaveNativeIds;
            boolean bl3 = bl = bl2 && tokenBuffer$Segment.hasIds();
            block14: while (true) {
                Object object;
                JsonToken jsonToken;
                if (++n2 >= 16) {
                    n2 = 0;
                    if ((tokenBuffer$Segment = tokenBuffer$Segment.next()) == null) break block32;
                    boolean bl4 = bl = bl2 && tokenBuffer$Segment.hasIds();
                }
                if ((jsonToken = tokenBuffer$Segment.type(n2)) == null) break block32;
                if (bl) {
                    object = tokenBuffer$Segment.findObjectId(n2);
                    if (object != null) {
                        jsonGenerator.writeObjectId(object);
                    }
                    if ((object = tokenBuffer$Segment.findTypeId(n2)) != null) {
                        jsonGenerator.writeTypeId(object);
                    }
                }
                switch (jsonToken) {
                    case START_OBJECT: {
                        jsonGenerator.writeStartObject();
                        continue block14;
                    }
                    case END_OBJECT: {
                        jsonGenerator.writeEndObject();
                        continue block14;
                    }
                    case START_ARRAY: {
                        jsonGenerator.writeStartArray();
                        continue block14;
                    }
                    case END_ARRAY: {
                        jsonGenerator.writeEndArray();
                        continue block14;
                    }
                    case FIELD_NAME: {
                        object = tokenBuffer$Segment.get(n2);
                        if (object instanceof SerializableString) {
                            jsonGenerator.writeFieldName((SerializableString)object);
                            continue block14;
                        }
                        jsonGenerator.writeFieldName((String)object);
                        continue block14;
                    }
                    case VALUE_STRING: {
                        object = tokenBuffer$Segment.get(n2);
                        if (object instanceof SerializableString) {
                            jsonGenerator.writeString((SerializableString)object);
                            continue block14;
                        }
                        jsonGenerator.writeString((String)object);
                        continue block14;
                    }
                    case VALUE_NUMBER_INT: {
                        object = tokenBuffer$Segment.get(n2);
                        if (object instanceof Integer) {
                            jsonGenerator.writeNumber((Integer)object);
                            continue block14;
                        }
                        if (object instanceof BigInteger) {
                            jsonGenerator.writeNumber((BigInteger)object);
                            continue block14;
                        }
                        if (object instanceof Long) {
                            jsonGenerator.writeNumber((Long)object);
                            continue block14;
                        }
                        if (object instanceof Short) {
                            jsonGenerator.writeNumber((Short)object);
                            continue block14;
                        }
                        jsonGenerator.writeNumber(((Number)object).intValue());
                        continue block14;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        object = tokenBuffer$Segment.get(n2);
                        if (object instanceof Double) {
                            jsonGenerator.writeNumber((Double)object);
                            continue block14;
                        }
                        if (object instanceof BigDecimal) {
                            jsonGenerator.writeNumber((BigDecimal)object);
                            continue block14;
                        }
                        if (object instanceof Float) {
                            jsonGenerator.writeNumber(((Float)object).floatValue());
                            continue block14;
                        }
                        if (object == null) {
                            jsonGenerator.writeNull();
                            continue block14;
                        }
                        if (object instanceof String) {
                            jsonGenerator.writeNumber((String)object);
                            continue block14;
                        }
                        this._reportError(String.format("Unrecognized value type for VALUE_NUMBER_FLOAT: %s, cannot serialize", object.getClass().getName()));
                        continue block14;
                    }
                    case VALUE_TRUE: {
                        jsonGenerator.writeBoolean(true);
                        continue block14;
                    }
                    case VALUE_FALSE: {
                        jsonGenerator.writeBoolean(false);
                        continue block14;
                    }
                    case VALUE_NULL: {
                        jsonGenerator.writeNull();
                        continue block14;
                    }
                    case VALUE_EMBEDDED_OBJECT: {
                        object = tokenBuffer$Segment.get(n2);
                        if (object instanceof RawValue) {
                            ((RawValue)object).serialize(jsonGenerator);
                            continue block14;
                        }
                        if (object instanceof JsonSerializable) {
                            jsonGenerator.writeObject(object);
                            continue block14;
                        }
                        jsonGenerator.writeEmbeddedObject(object);
                        continue block14;
                    }
                }
                break;
            }
            throw new RuntimeException("Internal error: should never end up through this code path");
        }
    }

    public TokenBuffer deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) {
        JsonToken jsonToken;
        if (!jsonParser.hasToken(JsonToken.FIELD_NAME)) {
            ((JsonGenerator)this).copyCurrentStructure(jsonParser);
            return this;
        }
        ((JsonGenerator)this).writeStartObject();
        do {
            ((JsonGenerator)this).copyCurrentStructure(jsonParser);
        } while ((jsonToken = jsonParser.nextToken()) == JsonToken.FIELD_NAME);
        if (jsonToken != JsonToken.END_OBJECT) {
            deserializationContext.reportWrongTokenException(TokenBuffer.class, JsonToken.END_OBJECT, "Expected END_OBJECT after copying contents of a JsonParser into TokenBuffer, got " + (Object)((Object)jsonToken), new Object[0]);
        }
        ((JsonGenerator)this).writeEndObject();
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[TokenBuffer: ");
        JsonParser jsonParser = this.asParser();
        int n2 = 0;
        boolean bl = this._hasNativeTypeIds || this._hasNativeObjectIds;
        while (true) {
            try {
                JsonToken jsonToken = jsonParser.nextToken();
                if (jsonToken == null) break;
                if (bl) {
                    this._appendNativeIds(stringBuilder);
                }
                if (n2 < 100) {
                    if (n2 > 0) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(jsonToken.toString());
                    if (jsonToken == JsonToken.FIELD_NAME) {
                        stringBuilder.append('(');
                        stringBuilder.append(jsonParser.currentName());
                        stringBuilder.append(')');
                    }
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException(iOException);
            }
            ++n2;
        }
        if (n2 >= 100) {
            stringBuilder.append(" ... (truncated ").append(n2 - 100).append(" entries)");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private final void _appendNativeIds(StringBuilder stringBuilder) {
        Object object = this._last.findObjectId(this._appendAt - 1);
        if (object != null) {
            stringBuilder.append("[objectId=").append(String.valueOf(object)).append(']');
        }
        if ((object = this._last.findTypeId(this._appendAt - 1)) != null) {
            stringBuilder.append("[typeId=").append(String.valueOf(object)).append(']');
        }
    }

    @Override
    public JsonGenerator enable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures |= jsonGenerator$Feature.getMask();
        return this;
    }

    @Override
    public JsonGenerator disable(JsonGenerator$Feature jsonGenerator$Feature) {
        this._generatorFeatures &= ~jsonGenerator$Feature.getMask();
        return this;
    }

    @Override
    public boolean isEnabled(JsonGenerator$Feature jsonGenerator$Feature) {
        return (this._generatorFeatures & jsonGenerator$Feature.getMask()) != 0;
    }

    @Override
    public int getFeatureMask() {
        return this._generatorFeatures;
    }

    @Override
    @Deprecated
    public JsonGenerator setFeatureMask(int n2) {
        this._generatorFeatures = n2;
        return this;
    }

    @Override
    public JsonGenerator overrideStdFeatures(int n2, int n3) {
        int n4 = ((JsonGenerator)this).getFeatureMask();
        this._generatorFeatures = n4 & ~n3 | n2 & n3;
        return this;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setCodec(ObjectCodec objectCodec) {
        this._objectCodec = objectCodec;
        return this;
    }

    @Override
    public ObjectCodec getCodec() {
        return this._objectCodec;
    }

    @Override
    public final JsonWriteContext getOutputContext() {
        return this._writeContext;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_WRITE_CAPABILITIES;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this._closed = true;
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public final void writeStartArray() {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext();
    }

    @Override
    public void writeStartArray(Object object) {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext(object);
    }

    @Override
    public void writeStartArray(Object object, int n2) {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_ARRAY);
        this._writeContext = this._writeContext.createChildArrayContext(object);
    }

    @Override
    public final void writeEndArray() {
        this._appendEndMarker(JsonToken.END_ARRAY);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeStartObject() {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._writeContext = this._writeContext.createChildObjectContext();
    }

    @Override
    public void writeStartObject(Object object) {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._writeContext = object = this._writeContext.createChildObjectContext(object);
    }

    @Override
    public void writeStartObject(Object object, int n2) {
        this._writeContext.writeValue();
        this._appendStartMarker(JsonToken.START_OBJECT);
        this._writeContext = object = this._writeContext.createChildObjectContext(object);
    }

    @Override
    public final void writeEndObject() {
        this._appendEndMarker(JsonToken.END_OBJECT);
        JsonWriteContext jsonWriteContext = this._writeContext.getParent();
        if (jsonWriteContext != null) {
            this._writeContext = jsonWriteContext;
        }
    }

    @Override
    public final void writeFieldName(String string) {
        this._writeContext.writeFieldName(string);
        this._appendFieldName(string);
    }

    @Override
    public void writeFieldName(SerializableString serializableString) {
        this._writeContext.writeFieldName(serializableString.getValue());
        this._appendFieldName(serializableString);
    }

    @Override
    public void writeString(String string) {
        if (string == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._appendValue(JsonToken.VALUE_STRING, string);
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        ((JsonGenerator)this).writeString(new String(cArray, n2, n3));
    }

    @Override
    public void writeString(SerializableString serializableString) {
        if (serializableString == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._appendValue(JsonToken.VALUE_STRING, serializableString);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRaw(char c2) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeRawValue(String string) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new RawValue(string));
    }

    @Override
    public void writeRawValue(String string, int n2, int n3) {
        if (n2 > 0 || n3 != string.length()) {
            int n4 = n2;
            string = string.substring(n4, n4 + n3);
        }
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new RawValue(string));
    }

    @Override
    public void writeRawValue(char[] cArray, int n2, int n3) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, new String(cArray, n2, n3));
    }

    @Override
    public void writeNumber(short s2) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, s2);
    }

    @Override
    public void writeNumber(int n2) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, n2);
    }

    @Override
    public void writeNumber(long l2) {
        this._appendValue(JsonToken.VALUE_NUMBER_INT, l2);
    }

    @Override
    public void writeNumber(double d2) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, d2);
    }

    @Override
    public void writeNumber(float f2) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, Float.valueOf(f2));
    }

    @Override
    public void writeNumber(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, bigDecimal);
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        if (bigInteger == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._appendValue(JsonToken.VALUE_NUMBER_INT, bigInteger);
    }

    @Override
    public void writeNumber(String string) {
        this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, string);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this._appendValue(bl ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE);
    }

    @Override
    public void writeNull() {
        this._appendValue(JsonToken.VALUE_NULL);
    }

    @Override
    public void writeObject(Object object) {
        if (object == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        Class<?> clazz = object.getClass();
        if (clazz == byte[].class || object instanceof RawValue) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
            return;
        }
        if (this._objectCodec == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
            return;
        }
        this._objectCodec.writeValue(this, object);
    }

    @Override
    public void writeTree(TreeNode treeNode) {
        if (treeNode == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        if (this._objectCodec == null) {
            this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, treeNode);
            return;
        }
        ((TreeCodec)this._objectCodec).writeTree(this, treeNode);
    }

    @Override
    public void writeBinary(Base64Variant object, byte[] byArray, int n2, int n3) {
        object = new byte[n3];
        System.arraycopy(byArray, n2, object, 0, n3);
        ((JsonGenerator)this).writeObject(object);
    }

    @Override
    public int writeBinary(Base64Variant base64Variant, InputStream inputStream, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canWriteTypeId() {
        return this._hasNativeTypeIds;
    }

    @Override
    public boolean canWriteObjectId() {
        return this._hasNativeObjectIds;
    }

    @Override
    public void writeTypeId(Object object) {
        this._typeId = object;
        this._hasNativeId = true;
    }

    @Override
    public void writeObjectId(Object object) {
        this._objectId = object;
        this._hasNativeId = true;
    }

    @Override
    public void writeEmbeddedObject(Object object) {
        this._appendValue(JsonToken.VALUE_EMBEDDED_OBJECT, object);
    }

    @Override
    public void copyCurrentEvent(JsonParser jsonParser) {
        if (this._mayHaveNativeIds) {
            this._checkNativeIds(jsonParser);
        }
        switch (jsonParser.currentToken()) {
            case START_OBJECT: {
                ((JsonGenerator)this).writeStartObject();
                return;
            }
            case END_OBJECT: {
                ((JsonGenerator)this).writeEndObject();
                return;
            }
            case START_ARRAY: {
                ((JsonGenerator)this).writeStartArray();
                return;
            }
            case END_ARRAY: {
                ((JsonGenerator)this).writeEndArray();
                return;
            }
            case FIELD_NAME: {
                ((JsonGenerator)this).writeFieldName(jsonParser.currentName());
                return;
            }
            case VALUE_STRING: {
                if (jsonParser.hasTextCharacters()) {
                    ((JsonGenerator)this).writeString(jsonParser.getTextCharacters(), jsonParser.getTextOffset(), jsonParser.getTextLength());
                    return;
                }
                ((JsonGenerator)this).writeString(jsonParser.getText());
                return;
            }
            case VALUE_NUMBER_INT: {
                switch (jsonParser.getNumberType()) {
                    case INT: {
                        ((JsonGenerator)this).writeNumber(jsonParser.getIntValue());
                        return;
                    }
                    case BIG_INTEGER: {
                        ((JsonGenerator)this).writeNumber(jsonParser.getBigIntegerValue());
                        return;
                    }
                }
                ((JsonGenerator)this).writeNumber(jsonParser.getLongValue());
                return;
            }
            case VALUE_NUMBER_FLOAT: {
                if (this._forceBigDecimal) {
                    ((JsonGenerator)this).writeNumber(jsonParser.getDecimalValue());
                    return;
                }
                switch (jsonParser.getNumberType()) {
                    case BIG_DECIMAL: {
                        ((JsonGenerator)this).writeNumber(jsonParser.getDecimalValue());
                        return;
                    }
                    case FLOAT: {
                        ((JsonGenerator)this).writeNumber(jsonParser.getFloatValue());
                        return;
                    }
                }
                ((JsonGenerator)this).writeNumber(jsonParser.getDoubleValue());
                return;
            }
            case VALUE_TRUE: {
                ((JsonGenerator)this).writeBoolean(true);
                return;
            }
            case VALUE_FALSE: {
                ((JsonGenerator)this).writeBoolean(false);
                return;
            }
            case VALUE_NULL: {
                ((JsonGenerator)this).writeNull();
                return;
            }
            case VALUE_EMBEDDED_OBJECT: {
                ((JsonGenerator)this).writeObject(jsonParser.getEmbeddedObject());
                return;
            }
        }
        throw new RuntimeException("Internal error: unexpected token: " + (Object)((Object)jsonParser.currentToken()));
    }

    @Override
    public void copyCurrentStructure(JsonParser jsonParser) {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.FIELD_NAME) {
            if (this._mayHaveNativeIds) {
                this._checkNativeIds(jsonParser);
            }
            ((JsonGenerator)this).writeFieldName(jsonParser.currentName());
            jsonToken = jsonParser.nextToken();
        } else if (jsonToken == null) {
            throw new IllegalStateException("No token available from argument `JsonParser`");
        }
        switch (jsonToken) {
            case START_ARRAY: {
                if (this._mayHaveNativeIds) {
                    this._checkNativeIds(jsonParser);
                }
                ((JsonGenerator)this).writeStartArray();
                this._copyBufferContents(jsonParser);
                return;
            }
            case START_OBJECT: {
                if (this._mayHaveNativeIds) {
                    this._checkNativeIds(jsonParser);
                }
                ((JsonGenerator)this).writeStartObject();
                this._copyBufferContents(jsonParser);
                return;
            }
            case END_ARRAY: {
                ((JsonGenerator)this).writeEndArray();
                return;
            }
            case END_OBJECT: {
                ((JsonGenerator)this).writeEndObject();
                return;
            }
        }
        this._copyBufferValue(jsonParser, jsonToken);
    }

    protected void _copyBufferContents(JsonParser jsonParser) {
        JsonToken jsonToken;
        int n2 = 1;
        block7: while ((jsonToken = jsonParser.nextToken()) != null) {
            switch (jsonToken) {
                case FIELD_NAME: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(jsonParser);
                    }
                    ((JsonGenerator)this).writeFieldName(jsonParser.currentName());
                    continue block7;
                }
                case START_ARRAY: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(jsonParser);
                    }
                    ((JsonGenerator)this).writeStartArray();
                    ++n2;
                    continue block7;
                }
                case START_OBJECT: {
                    if (this._mayHaveNativeIds) {
                        this._checkNativeIds(jsonParser);
                    }
                    ((JsonGenerator)this).writeStartObject();
                    ++n2;
                    continue block7;
                }
                case END_ARRAY: {
                    ((JsonGenerator)this).writeEndArray();
                    if (--n2 != 0) continue block7;
                    return;
                }
                case END_OBJECT: {
                    ((JsonGenerator)this).writeEndObject();
                    if (--n2 != 0) continue block7;
                    return;
                }
            }
            this._copyBufferValue(jsonParser, jsonToken);
        }
    }

    private void _copyBufferValue(JsonParser object, JsonToken jsonToken) {
        if (this._mayHaveNativeIds) {
            this._checkNativeIds((JsonParser)object);
        }
        switch (jsonToken) {
            case VALUE_STRING: {
                if (((JsonParser)object).hasTextCharacters()) {
                    ((JsonGenerator)this).writeString(((JsonParser)object).getTextCharacters(), ((JsonParser)object).getTextOffset(), ((JsonParser)object).getTextLength());
                    return;
                }
                ((JsonGenerator)this).writeString(((JsonParser)object).getText());
                return;
            }
            case VALUE_NUMBER_INT: {
                switch (((JsonParser)object).getNumberType()) {
                    case INT: {
                        ((JsonGenerator)this).writeNumber(((JsonParser)object).getIntValue());
                        return;
                    }
                    case BIG_INTEGER: {
                        ((JsonGenerator)this).writeNumber(((JsonParser)object).getBigIntegerValue());
                        return;
                    }
                }
                ((JsonGenerator)this).writeNumber(((JsonParser)object).getLongValue());
                return;
            }
            case VALUE_NUMBER_FLOAT: {
                if (this._forceBigDecimal) {
                    ((JsonGenerator)this).writeNumber(((JsonParser)object).getDecimalValue());
                    return;
                }
                object = ((JsonParser)object).getNumberValueExact();
                this._appendValue(JsonToken.VALUE_NUMBER_FLOAT, object);
                return;
            }
            case VALUE_TRUE: {
                ((JsonGenerator)this).writeBoolean(true);
                return;
            }
            case VALUE_FALSE: {
                ((JsonGenerator)this).writeBoolean(false);
                return;
            }
            case VALUE_NULL: {
                ((JsonGenerator)this).writeNull();
                return;
            }
            case VALUE_EMBEDDED_OBJECT: {
                ((JsonGenerator)this).writeObject(((JsonParser)object).getEmbeddedObject());
                return;
            }
        }
        throw new RuntimeException("Internal error: unexpected token: " + (Object)((Object)jsonToken));
    }

    private final void _checkNativeIds(JsonParser jsonParser) {
        this._typeId = jsonParser.getTypeId();
        if (this._typeId != null) {
            this._hasNativeId = true;
        }
        if ((this._objectId = jsonParser.getObjectId()) != null) {
            this._hasNativeId = true;
        }
    }

    protected final void _appendValue(JsonToken object) {
        this._writeContext.writeValue();
        object = this._hasNativeId ? this._last.append(this._appendAt, (JsonToken)((Object)object), this._objectId, this._typeId) : this._last.append(this._appendAt, (JsonToken)((Object)object));
        if (object == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    protected final void _appendValue(JsonToken object, Object object2) {
        this._writeContext.writeValue();
        object = this._hasNativeId ? this._last.append(this._appendAt, (JsonToken)((Object)object), object2, this._objectId, this._typeId) : this._last.append(this._appendAt, (JsonToken)((Object)object), object2);
        if (object == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    protected final void _appendFieldName(Object object) {
        object = this._hasNativeId ? this._last.append(this._appendAt, JsonToken.FIELD_NAME, object, this._objectId, this._typeId) : this._last.append(this._appendAt, JsonToken.FIELD_NAME, object);
        if (object == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    protected final void _appendStartMarker(JsonToken object) {
        object = this._hasNativeId ? this._last.append(this._appendAt, (JsonToken)((Object)object), this._objectId, this._typeId) : this._last.append(this._appendAt, (JsonToken)((Object)object));
        if (object == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    protected final void _appendEndMarker(JsonToken object) {
        if ((object = this._last.append(this._appendAt, (JsonToken)((Object)object))) == null) {
            ++this._appendAt;
            return;
        }
        this._last = object;
        this._appendAt = 1;
    }

    @Override
    public void _reportUnsupportedOperation() {
        throw new UnsupportedOperationException("Called operation not supported for TokenBuffer");
    }
}

