/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.util;

import com.fasterxml.jackson.databind.JavaType;

public class TypeKey {
    protected int _hashCode;
    protected Class<?> _class;
    protected JavaType _type;
    protected boolean _isTyped;

    public TypeKey() {
    }

    public TypeKey(TypeKey typeKey) {
        this._hashCode = typeKey._hashCode;
        this._class = typeKey._class;
        this._type = typeKey._type;
        this._isTyped = typeKey._isTyped;
    }

    public TypeKey(Class<?> clazz, boolean bl) {
        this._class = clazz;
        this._type = null;
        this._isTyped = bl;
        this._hashCode = bl ? TypeKey.typedHash(clazz) : TypeKey.untypedHash(clazz);
    }

    public TypeKey(JavaType javaType, boolean bl) {
        this._type = javaType;
        this._class = null;
        this._isTyped = bl;
        this._hashCode = bl ? TypeKey.typedHash(javaType) : TypeKey.untypedHash(javaType);
    }

    public static final int untypedHash(Class<?> clazz) {
        return clazz.getName().hashCode();
    }

    public static final int typedHash(Class<?> clazz) {
        return clazz.getName().hashCode() + 1;
    }

    public static final int untypedHash(JavaType javaType) {
        return javaType.hashCode() - 1;
    }

    public static final int typedHash(JavaType javaType) {
        return javaType.hashCode() - 2;
    }

    public final void resetTyped(Class<?> clazz) {
        this._type = null;
        this._class = clazz;
        this._isTyped = true;
        this._hashCode = TypeKey.typedHash(clazz);
    }

    public final void resetUntyped(Class<?> clazz) {
        this._type = null;
        this._class = clazz;
        this._isTyped = false;
        this._hashCode = TypeKey.untypedHash(clazz);
    }

    public final void resetTyped(JavaType javaType) {
        this._type = javaType;
        this._class = null;
        this._isTyped = true;
        this._hashCode = TypeKey.typedHash(javaType);
    }

    public final void resetUntyped(JavaType javaType) {
        this._type = javaType;
        this._class = null;
        this._isTyped = false;
        this._hashCode = TypeKey.untypedHash(javaType);
    }

    public boolean isTyped() {
        return this._isTyped;
    }

    public Class<?> getRawType() {
        return this._class;
    }

    public JavaType getType() {
        return this._type;
    }

    public final int hashCode() {
        return this._hashCode;
    }

    public final String toString() {
        if (this._class != null) {
            return "{class: " + this._class.getName() + ", typed? " + this._isTyped + "}";
        }
        return "{type: " + this._type + ", typed? " + this._isTyped + "}";
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        object = (TypeKey)object;
        if (((TypeKey)object)._isTyped == this._isTyped) {
            if (this._class != null) {
                return ((TypeKey)object)._class == this._class;
            }
            return this._type.equals(((TypeKey)object)._type);
        }
        return false;
    }
}

