/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.format.InputAccessor;
import com.fasterxml.jackson.core.format.MatchStrength;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsFactoryBuilder;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsGenerator;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsParser;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.fasterxml.jackson.dataformat.javaprop.PackageVersion;
import com.fasterxml.jackson.dataformat.javaprop.impl.PropertiesBackedGenerator;
import com.fasterxml.jackson.dataformat.javaprop.impl.WriterBackedGenerator;
import com.fasterxml.jackson.dataformat.javaprop.io.Latin1Reader;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public class JavaPropsFactory
extends JsonFactory {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_JAVA_PROPERTIES = "java_properties";
    protected static final String CHARSET_ID_LATIN1 = "ISO-8859-1";

    public JavaPropsFactory() {
    }

    public JavaPropsFactory(ObjectCodec objectCodec) {
        super(objectCodec);
    }

    protected JavaPropsFactory(JavaPropsFactory javaPropsFactory, ObjectCodec objectCodec) {
        super(javaPropsFactory, objectCodec);
    }

    protected JavaPropsFactory(JavaPropsFactoryBuilder javaPropsFactoryBuilder) {
        super(javaPropsFactoryBuilder, false);
    }

    public JavaPropsFactoryBuilder rebuild() {
        return new JavaPropsFactoryBuilder(this);
    }

    public static JavaPropsFactoryBuilder builder() {
        return new JavaPropsFactoryBuilder();
    }

    @Override
    public JavaPropsFactory copy() {
        this._checkInvalidCopy(JavaPropsFactory.class);
        return new JavaPropsFactory(this, null);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_JAVA_PROPERTIES;
    }

    @Override
    public MatchStrength hasFormat(InputAccessor inputAccessor) {
        return MatchStrength.INCONCLUSIVE;
    }

    @Override
    public boolean requiresPropertyOrdering() {
        return false;
    }

    @Override
    public boolean canHandleBinaryNatively() {
        return false;
    }

    @Override
    public boolean canUseCharArrays() {
        return false;
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        return formatSchema instanceof JavaPropsSchema;
    }

    public JavaPropsParser createParser(Map<?, ?> map) {
        JavaPropsFactory javaPropsFactory = this;
        return new JavaPropsParser(javaPropsFactory._createContext(javaPropsFactory._createContentReference(map), true), this._parserFeatures, map, this._objectCodec, map);
    }

    @Deprecated
    public JavaPropsParser createParser(Properties properties) {
        JavaPropsFactory javaPropsFactory = this;
        return new JavaPropsParser(javaPropsFactory._createContext(javaPropsFactory._createContentReference(properties), true), this._parserFeatures, properties, this._objectCodec, properties);
    }

    @Deprecated
    public JavaPropsGenerator createGenerator(Properties properties) {
        JavaPropsFactory javaPropsFactory = this;
        IOContext iOContext = javaPropsFactory._createContext(javaPropsFactory._createContentReference(properties), true);
        return new PropertiesBackedGenerator(iOContext, properties, this._generatorFeatures, this._objectCodec);
    }

    public JavaPropsGenerator createGenerator(Map<?, ?> map, JavaPropsSchema object) {
        JavaPropsFactory javaPropsFactory = this;
        object = javaPropsFactory._createContext(javaPropsFactory._createContentReference(map), true);
        return new PropertiesBackedGenerator((IOContext)object, map, this._generatorFeatures, this._objectCodec);
    }

    @Override
    public JsonParser createParser(File file) {
        JavaPropsFactory javaPropsFactory = this;
        IOContext iOContext = javaPropsFactory._createContext(javaPropsFactory._createContentReference(file), true);
        JavaPropsFactory javaPropsFactory2 = this;
        return javaPropsFactory2._createParser(javaPropsFactory2._decorate(new FileInputStream(file), iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(URL uRL) {
        JavaPropsFactory javaPropsFactory = this;
        IOContext iOContext = javaPropsFactory._createContext(javaPropsFactory._createContentReference(uRL), true);
        JavaPropsFactory javaPropsFactory2 = this;
        return javaPropsFactory2._createParser(javaPropsFactory2._decorate(this._optimizedStreamFromURL(uRL), iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(InputStream inputStream) {
        JavaPropsFactory javaPropsFactory = this;
        IOContext iOContext = javaPropsFactory._createContext(javaPropsFactory._createContentReference(inputStream), false);
        JavaPropsFactory javaPropsFactory2 = this;
        return javaPropsFactory2._createParser(javaPropsFactory2._decorate(inputStream, iOContext), iOContext);
    }

    @Override
    public JsonParser createParser(byte[] byArray) {
        InputStream inputStream;
        JavaPropsFactory javaPropsFactory = this;
        IOContext iOContext = javaPropsFactory._createContext(javaPropsFactory._createContentReference(byArray), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, 0, byArray.length)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, 0, byArray.length, iOContext);
    }

    @Override
    public JsonParser createParser(byte[] byArray, int n2, int n3) {
        InputStream inputStream;
        JavaPropsFactory javaPropsFactory = this;
        IOContext iOContext = javaPropsFactory._createContext(javaPropsFactory._createContentReference(byArray, n2, n3), true);
        if (this._inputDecorator != null && (inputStream = this._inputDecorator.decorate(iOContext, byArray, n2, n3)) != null) {
            return this._createParser(inputStream, iOContext);
        }
        return this._createParser(byArray, n2, n3, iOContext);
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream, JsonEncoding jsonEncoding) {
        JavaPropsFactory javaPropsFactory = this;
        IOContext iOContext = javaPropsFactory._createContext(javaPropsFactory._createContentReference(outputStream), false);
        iOContext.setEncoding(jsonEncoding);
        return this._createJavaPropsGenerator(iOContext, this._generatorFeatures, this._objectCodec, this._decorate(outputStream, iOContext));
    }

    @Override
    public JsonGenerator createGenerator(OutputStream outputStream) {
        JavaPropsFactory javaPropsFactory = this;
        IOContext iOContext = javaPropsFactory._createContext(javaPropsFactory._createContentReference(outputStream), false);
        return this._createJavaPropsGenerator(iOContext, this._generatorFeatures, this._objectCodec, this._decorate(outputStream, iOContext));
    }

    @Override
    public JsonParser _createParser(InputStream inputStream, IOContext iOContext) {
        Properties properties = this._loadProperties(inputStream, iOContext);
        return new JavaPropsParser(iOContext, this._parserFeatures, inputStream, this._objectCodec, properties);
    }

    @Override
    public JsonParser _createParser(Reader reader, IOContext iOContext) {
        Properties properties = this._loadProperties(reader, iOContext);
        return new JavaPropsParser(iOContext, this._parserFeatures, reader, this._objectCodec, properties);
    }

    @Override
    public JsonParser _createParser(char[] cArray, int n2, int n3, IOContext iOContext, boolean bl) {
        return this._createParser(new CharArrayReader(cArray, n2, n3), iOContext);
    }

    @Override
    public JsonParser _createParser(byte[] byArray, int n2, int n3, IOContext iOContext) {
        return this._createParser(new Latin1Reader(byArray, n2, n3), iOContext);
    }

    @Override
    public JsonGenerator _createGenerator(Writer writer, IOContext iOContext) {
        return new WriterBackedGenerator(iOContext, writer, this._generatorFeatures, this._objectCodec);
    }

    @Override
    public JsonGenerator _createUTF8Generator(OutputStream outputStream, IOContext iOContext) {
        return this._createJavaPropsGenerator(iOContext, this._generatorFeatures, this._objectCodec, outputStream);
    }

    @Override
    public Writer _createWriter(OutputStream outputStream, JsonEncoding jsonEncoding, IOContext iOContext) {
        return new OutputStreamWriter(outputStream, CHARSET_ID_LATIN1);
    }

    protected Properties _loadProperties(InputStream inputStream, IOContext iOContext) {
        return this._loadProperties(new Latin1Reader(iOContext, inputStream), iOContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Properties _loadProperties(Reader reader, IOContext object) {
        Properties properties = new Properties();
        if (((IOContext)object).isResourceManaged() || this.isEnabled(StreamReadFeature.AUTO_CLOSE_SOURCE)) {
            object = null;
            try {
                properties.load(reader);
                if (reader == null) return properties;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    object = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (reader == null) throw throwable3;
                    if (object != null) {
                        try {
                            reader.close();
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)object).addSuppressed(throwable4);
                        }
                        throw throwable3;
                    } else {
                        reader.close();
                    }
                    throw throwable3;
                }
            }
            reader.close();
            return properties;
        }
        properties.load(reader);
        return properties;
    }

    private final JsonGenerator _createJavaPropsGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec, OutputStream outputStream) {
        return new WriterBackedGenerator(iOContext, this._createWriter(outputStream, null, iOContext), n2, this._objectCodec);
    }
}

