/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.javaprop;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonGenerator$Feature;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.StreamWriteCapability;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.IOContext;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.core.util.JacksonFeatureSet;
import com.fasterxml.jackson.dataformat.javaprop.JavaPropsSchema;
import com.fasterxml.jackson.dataformat.javaprop.PackageVersion;
import com.fasterxml.jackson.dataformat.javaprop.io.JPropWriteContext;
import com.fasterxml.jackson.dataformat.javaprop.util.Markers;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;

public abstract class JavaPropsGenerator
extends GeneratorBase {
    protected static final int SHORT_WRITE = 100;
    protected static final JsonWriteContext BOGUS_WRITE_CONTEXT = JsonWriteContext.createRootContext(null);
    private static final JavaPropsSchema EMPTY_SCHEMA = JavaPropsSchema.emptySchema();
    public final IOContext _ioContext;
    public JavaPropsSchema _schema = EMPTY_SCHEMA;
    protected JPropWriteContext _jpropContext;
    public final StringBuilder _basePath = new StringBuilder(50);
    public boolean _headerChecked;
    protected int _indentLength;

    public JavaPropsGenerator(IOContext iOContext, int n2, ObjectCodec objectCodec) {
        super(n2, objectCodec, BOGUS_WRITE_CONTEXT);
        this._ioContext = iOContext;
        this._jpropContext = JPropWriteContext.createRootContext();
    }

    @Override
    public Object currentValue() {
        return ((JsonStreamContext)this._jpropContext).getCurrentValue();
    }

    @Override
    public Object getCurrentValue() {
        return ((JsonStreamContext)this._jpropContext).getCurrentValue();
    }

    @Override
    public void assignCurrentValue(Object object) {
        ((JsonStreamContext)this._jpropContext).setCurrentValue(object);
    }

    @Override
    public void setCurrentValue(Object object) {
        ((JsonStreamContext)this._jpropContext).setCurrentValue(object);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public JsonGenerator useDefaultPrettyPrinter() {
        return this;
    }

    @Override
    public JsonGenerator setPrettyPrinter(PrettyPrinter prettyPrinter) {
        return this;
    }

    @Override
    public void setSchema(FormatSchema object) {
        if (object instanceof JavaPropsSchema) {
            this._schema = (JavaPropsSchema)object;
            if (this._jpropContext.inRoot()) {
                object = this._schema.lineIndentation();
                int n2 = this._indentLength = object == null ? 0 : ((String)object).length();
                if (this._indentLength > 0) {
                    this._basePath.setLength(0);
                    this._basePath.append((String)object);
                    this._jpropContext = JPropWriteContext.createRootContext(this._indentLength);
                }
                if ((object = this._schema.prefix()) != null) {
                    this._basePath.append((String)object);
                }
            }
            return;
        }
        super.setSchema((FormatSchema)object);
    }

    @Override
    public FormatSchema getSchema() {
        return this._schema;
    }

    @Override
    public boolean canUseSchema(FormatSchema formatSchema) {
        return formatSchema instanceof JavaPropsSchema;
    }

    @Override
    public boolean canWriteObjectId() {
        return false;
    }

    @Override
    public boolean canWriteTypeId() {
        return false;
    }

    @Override
    public boolean canWriteBinaryNatively() {
        return false;
    }

    @Override
    public boolean canOmitFields() {
        return true;
    }

    @Override
    public boolean canWriteFormattedNumbers() {
        return true;
    }

    @Override
    public JacksonFeatureSet<StreamWriteCapability> getWriteCapabilities() {
        return DEFAULT_TEXTUAL_WRITE_CAPABILITIES;
    }

    @Override
    public JsonStreamContext getOutputContext() {
        return this._jpropContext;
    }

    @Override
    public void writeFieldName(String string) {
        String string2;
        if (!this._jpropContext.writeFieldName(string)) {
            this._reportError("Can not write a field name, expecting a value");
        }
        if (!this._headerChecked) {
            this._headerChecked = true;
            string2 = this._schema.header();
            if (string2 != null && !string2.isEmpty()) {
                this._writeRaw(string2);
            }
        }
        this._jpropContext.truncatePath(this._basePath);
        if (this._basePath.length() > this._indentLength && !(string2 = this._schema.pathSeparator()).isEmpty()) {
            this._basePath.append(string2);
        }
        JavaPropsGenerator javaPropsGenerator = this;
        javaPropsGenerator._appendFieldName(javaPropsGenerator._basePath, string);
    }

    protected abstract void _appendFieldName(StringBuilder var1, String var2);

    @Override
    public void writeStartArray() {
        this._verifyValueWrite("start an array");
        this._jpropContext = this._jpropContext.createChildArrayContext(this._basePath.length());
    }

    @Override
    public void writeEndArray() {
        if (!this._jpropContext.inArray()) {
            this._reportError("Current context not an Array but " + this._jpropContext.typeDesc());
        }
        this._jpropContext = this._jpropContext.getParent();
    }

    @Override
    public void writeStartObject() {
        this._verifyValueWrite("start an object");
        this._jpropContext = this._jpropContext.createChildObjectContext(this._basePath.length());
    }

    @Override
    public void writeEndObject() {
        if (!this._jpropContext.inObject()) {
            this._reportError("Current context not an Ibject but " + this._jpropContext.typeDesc());
        }
        this._jpropContext = this._jpropContext.getParent();
    }

    @Override
    public void writeString(String string) {
        if (string == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write String value");
        this._writeEscapedEntry(string);
    }

    @Override
    public void writeString(char[] cArray, int n2, int n3) {
        this._verifyValueWrite("write String value");
        this._writeEscapedEntry(cArray, n2, n3);
    }

    @Override
    public void writeRawUTF8String(byte[] byArray, int n2, int n3) {
        this._reportUnsupportedOperation();
    }

    @Override
    public void writeUTF8String(byte[] byArray, int n2, int n3) {
        ((JsonGenerator)this).writeString(new String(byArray, n2, n3, "UTF-8"));
    }

    @Override
    public void writeRaw(String string) {
        this._writeRaw(string);
    }

    @Override
    public void writeRaw(String string, int n2, int n3) {
        int n4 = n2;
        this._writeRaw(string.substring(n4, n4 + n3));
    }

    @Override
    public void writeRaw(char[] cArray, int n2, int n3) {
        this._writeRaw(cArray, n2, n3);
    }

    @Override
    public void writeRaw(char c2) {
        this._writeRaw(c2);
    }

    @Override
    public void writeRaw(SerializableString serializableString) {
        ((JsonGenerator)this).writeRaw(serializableString.toString());
    }

    @Override
    public void writeBinary(Base64Variant object, byte[] byArray, int n2, int n3) {
        if (byArray == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write Binary value");
        if (n2 > 0 || n2 + n3 != byArray.length) {
            int n4 = n2;
            byArray = Arrays.copyOfRange(byArray, n4, n4 + n3);
        }
        object = ((Base64Variant)object).encode(byArray);
        this._writeEscapedEntry((String)object);
    }

    @Override
    public void writeBoolean(boolean bl) {
        this._verifyValueWrite("write boolean value");
        this._writeUnescapedEntry(bl ? "true" : "false");
    }

    @Override
    public void writeNumber(int n2) {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(n2));
    }

    @Override
    public void writeNumber(long l2) {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(l2));
    }

    @Override
    public void writeNumber(BigInteger bigInteger) {
        if (bigInteger == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(bigInteger));
    }

    @Override
    public void writeNumber(double d2) {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(d2));
    }

    @Override
    public void writeNumber(float f2) {
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(String.valueOf(f2));
    }

    @Override
    public void writeNumber(BigDecimal object) {
        if (object == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        object = ((JsonGenerator)this).isEnabled(JsonGenerator$Feature.WRITE_BIGDECIMAL_AS_PLAIN) ? ((BigDecimal)object).toPlainString() : ((BigDecimal)object).toString();
        this._writeUnescapedEntry((String)object);
    }

    @Override
    public void writeNumber(String string) {
        if (string == null) {
            ((JsonGenerator)this).writeNull();
            return;
        }
        this._verifyValueWrite("write number");
        this._writeUnescapedEntry(string);
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite("write null value");
        this._writeUnescapedEntry("");
    }

    @Override
    public void _verifyValueWrite(String string) {
        if (!this._jpropContext.writeValue()) {
            this._reportError("Can not " + string + ", expecting field name");
        }
        if (this._jpropContext.inArray()) {
            String string2;
            this._jpropContext.truncatePath(this._basePath);
            int n2 = this._jpropContext.getCurrentIndex() + this._schema.firstArrayOffset();
            if (this._schema.writeIndexUsingMarkers()) {
                Markers markers = this._schema.indexMarker();
                this._basePath.append(markers.getStart());
                this._basePath.append(n2);
                this._basePath.append(markers.getEnd());
                return;
            }
            if (this._basePath.length() > 0 && !(string2 = this._schema.pathSeparator()).isEmpty()) {
                this._basePath.append(string2);
            }
            this._basePath.append(n2);
        }
    }

    protected abstract void _writeEscapedEntry(String var1);

    protected abstract void _writeEscapedEntry(char[] var1, int var2, int var3);

    protected abstract void _writeUnescapedEntry(String var1);

    protected abstract void _writeRaw(char var1);

    protected abstract void _writeRaw(String var1);

    protected abstract void _writeRaw(StringBuilder var1);

    protected abstract void _writeRaw(char[] var1, int var2, int var3);
}

